/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class ExpressionMatrices {
    public static void merge(ExpressionMatrix srcMatrix, Collection<String> srcColumNames, ExpressionMatrix destMatrix, String destColumName) {
        Objects.requireNonNull(srcMatrix, "srcMatrix argument cannot be null");
        Objects.requireNonNull(srcColumNames, "srcColumNames argument cannot be null");
        Objects.requireNonNull(destMatrix, "destMatrix argument cannot be null");
        Objects.requireNonNull(destColumName, "destColumName argument cannot be null");
        for (String rowName : srcMatrix.getRowNames()) {
            double sum = 0.0;
            for (String columnName : srcColumNames) {
                sum += ((Double)srcMatrix.getValue(rowName, columnName)).doubleValue();
            }
            destMatrix.setValue(rowName, destColumName, sum);
        }
    }

    public static void removeEmptyRows(ExpressionMatrix matrix) {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        for (String rowName : matrix.getRowNames()) {
            List row = matrix.getRowValues(rowName);
            boolean findNonZero = false;
            for (Double v : row) {
                if (v == 0.0) continue;
                findNonZero = true;
                break;
            }
            if (findNonZero) continue;
            matrix.removeRow(rowName);
        }
    }

    public static void reverse(ExpressionMatrix srcMatrix, ExpressionMatrix destMatrix) {
        Objects.requireNonNull(srcMatrix, "matrix argument cannot be null");
        Objects.requireNonNull(destMatrix, "matrix argument cannot be null");
        for (String rowName : srcMatrix.getRowNames()) {
            for (String columnName : srcMatrix.getColumnNames()) {
                destMatrix.setValue(columnName, rowName, srcMatrix.getValue(rowName, columnName));
            }
        }
    }
}

