/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.EntryMetadata;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;

public class GFFEntry {
    private static final Pattern SEMI_COMA_SPLIT_PATTERN = Pattern.compile(";");
    private static final Pattern COMA_SPLIT_PATTERN = Pattern.compile(",");
    private final EntryMetadata metadata;
    private String seqId;
    private String source;
    private String type;
    private int start;
    private int end;
    private double score;
    private char strand;
    private int phase;
    private final Map<String, String> attributes = new LinkedHashMap<String, String>();

    public final EntryMetadata getMetadata() {
        return this.metadata;
    }

    @Deprecated
    public final int getId() {
        return -1;
    }

    public final String getSeqId() {
        return this.seqId;
    }

    public final String getSource() {
        return this.source;
    }

    public final String getType() {
        return this.type;
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public final int getLength() {
        return this.end - this.start + 1;
    }

    public final double getScore() {
        return this.score;
    }

    public final char getStrand() {
        return this.strand;
    }

    public final int getPhase() {
        return this.phase;
    }

    @Deprecated
    public final Set<String> getMetadataKeyNames() {
        return this.metadata.keySet();
    }

    public final Set<String> getAttributesNames() {
        return Collections.unmodifiableSet(this.attributes.keySet());
    }

    @Deprecated
    public final boolean isMetaDataEntry(String key) {
        return this.metadata.containsKey(key);
    }

    public final boolean isAttribute(String attributeName) {
        return this.attributes.containsKey(attributeName);
    }

    @Deprecated
    public final List<String> getMetadataEntryValues(String key) {
        return this.metadata.get(key);
    }

    public final String getAttributeValue(String attributeName) {
        return this.attributes.get(attributeName);
    }

    @Deprecated
    public final void setId(int id) {
    }

    public final void setSeqId(String seqId) {
        this.seqId = seqId == null || ".".equals(seqId) ? "" : seqId.trim();
    }

    public final void setSource(String source) {
        this.source = source == null || ".".equals(source) ? "" : source.trim();
    }

    public final void setType(String type) {
        this.type = type == null || ".".equals(type) ? "" : type.trim();
    }

    public final void setStart(int start) {
        this.start = start < 1 ? -1 : start;
    }

    public final void setEnd(int end) {
        this.end = end < 1 ? -1 : end;
    }

    public final void setScore(double score) {
        this.score = score;
    }

    public final void setStrand(char strand) {
        switch (strand) {
            case '+': 
            case '-': 
            case '.': 
            case '?': {
                this.strand = strand;
                break;
            }
            default: {
                this.strand = (char)46;
            }
        }
    }

    public final void setPhase(int phase) {
        this.phase = phase < 0 || phase > 2 ? -1 : phase;
    }

    @Deprecated
    public final boolean addMetaDataEntry(String key, String value) {
        return this.metadata.add(key, value);
    }

    @Deprecated
    public final boolean addMetaDataEntries(Map<String, List<String>> entries) {
        return this.metadata.add(entries);
    }

    public final boolean setAttributeValue(String attributeName, String value) {
        if (attributeName == null || value == null) {
            return false;
        }
        this.attributes.put(attributeName, value);
        return true;
    }

    @Deprecated
    public final boolean removeMetaDataEntry(String key) {
        return this.metadata.remove(key);
    }

    public final boolean removeAttribute(String attributeName) {
        return this.attributes.remove(attributeName) != null;
    }

    public final void clear() {
        this.seqId = "";
        this.source = "";
        this.type = "";
        this.start = -1;
        this.end = -1;
        this.score = Double.NaN;
        this.strand = (char)46;
        this.phase = -1;
        this.attributes.clear();
    }

    @Deprecated
    public final void clearMetaData() {
        this.metadata.clear();
    }

    public final boolean isValidEntry() {
        return this.isValidStartAndEnd();
    }

    public final boolean isValidStartAndEnd() {
        if (this.start < 1) {
            return false;
        }
        return this.end >= this.start;
    }

    public final boolean isValidStrand() {
        return true;
    }

    public final boolean isValidPhase() {
        return !("CDS".equals(this.type) ? this.phase == -1 : this.phase != -1);
    }

    private static int parseInt(String s, int defaultValue) {
        try {
            return Integer.parseInt(s.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static double parseDouble(String s, double defaultValue) {
        try {
            return Double.parseDouble(s.trim());
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private String parseCommon(String s) throws BadBioEntryException {
        if (s == null) {
            throw new NullPointerException("String to parse is null");
        }
        List fields = GuavaCompatibility.splitToList((Splitter)Splitter.on((char)'\t').trimResults(), (CharSequence)s);
        if (fields.size() != 9) {
            throw new BadBioEntryException("Error in GFF parsing line (" + s.split("\t").length + " fields, 9 attempted)", s);
        }
        this.setSeqId((String)fields.get(0));
        this.setSource((String)fields.get(1));
        this.setType((String)fields.get(2));
        this.setStart(GFFEntry.parseInt((String)fields.get(3), Integer.MIN_VALUE));
        this.setEnd(GFFEntry.parseInt((String)fields.get(4), Integer.MIN_VALUE));
        this.setScore(GFFEntry.parseDouble((String)fields.get(5), Double.NaN));
        this.setStrand(((String)fields.get(6)).length() == 0 ? (char)'.' : ((String)fields.get(6)).charAt(0));
        this.setPhase(GFFEntry.parseInt((String)fields.get(7), -1));
        return (String)fields.get(8);
    }

    private void parseGFF3Attributes(String attributesField) {
        String[] fields;
        this.attributes.clear();
        if ("".equals(attributesField) || ".".equals(attributesField)) {
            return;
        }
        String s = attributesField.trim();
        for (String f : fields = SEMI_COMA_SPLIT_PATTERN.split(s)) {
            int indexEquals = f.indexOf(61);
            if (indexEquals == -1) continue;
            String key = f.substring(0, indexEquals).trim();
            String value = f.substring(indexEquals + 1).trim();
            this.setAttributeValue(key, value);
        }
    }

    private void parseGTFAttributes(String attributesField) {
        String[] fields;
        this.attributes.clear();
        if ("".equals(attributesField) || ".".equals(attributesField)) {
            return;
        }
        String s = attributesField.trim();
        for (String f : fields = SEMI_COMA_SPLIT_PATTERN.split(s)) {
            int indexEquals;
            if ((f = f.trim()).isEmpty() || (indexEquals = f.indexOf(32)) == -1) continue;
            String key = f.substring(0, indexEquals).trim();
            String value = StringUtils.unDoubleQuotes((String)f.substring(indexEquals + 1).trim()).trim();
            if (this.getAttributesNames().contains(key)) {
                this.setAttributeValue(key, this.getAttributeValue(key) + ',' + value);
                continue;
            }
            this.setAttributeValue(key, value);
        }
    }

    @Deprecated
    public void parse(String s) throws BadBioEntryException {
        this.parseGFF3(s);
    }

    public void parseGFF3(String s) throws BadBioEntryException {
        String attributeField = this.parseCommon(s);
        this.parseGFF3Attributes(attributeField);
    }

    public void parseGTF(String s) throws BadBioEntryException {
        String attributeField = this.parseCommon(s);
        this.parseGTFAttributes(attributeField);
    }

    private String attributesToGFF3String() {
        if (this.attributes.size() == 0) {
            return ".";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> e : this.attributes.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(';');
            }
            sb.append(StringUtils.protectGFF((String)e.getKey()));
            sb.append('=');
            sb.append(StringUtils.protectGFF((String)e.getValue()).replace("\\,", ","));
        }
        return sb.toString();
    }

    private String attributesToGTFString() {
        if (this.attributes.size() == 0) {
            return ".";
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> e : this.attributes.entrySet()) {
            String key = e.getKey();
            for (String value : COMA_SPLIT_PATTERN.split(e.getValue())) {
                if (first) {
                    first = false;
                } else {
                    sb.append(' ');
                }
                sb.append(key);
                sb.append(" \"");
                sb.append(value);
                sb.append('\"');
                sb.append(';');
            }
        }
        return sb.toString();
    }

    public String toGFF3() {
        String seqId = this.getSeqId();
        String source = this.getSource();
        String type = this.getType();
        return ("".equals(seqId) ? "." : StringUtils.protectGFF((String)seqId)) + '\t' + ("".equals(source) ? "." : StringUtils.protectGFF((String)source)) + '\t' + ("".equals(type) ? "." : StringUtils.protectGFF((String)type)) + '\t' + (this.getStart() == -1 ? "." : Integer.valueOf(this.getStart())) + '\t' + (this.getEnd() == -1 ? "." : Integer.valueOf(this.getEnd())) + '\t' + (Double.isNaN(this.getScore()) ? "." : Double.valueOf(this.getScore())) + '\t' + this.getStrand() + '\t' + (this.getPhase() == -1 ? "." : Integer.valueOf(this.getPhase())) + '\t' + this.attributesToGFF3String();
    }

    public String toGTF() {
        String seqId = this.getSeqId();
        String source = this.getSource();
        String type = this.getType();
        return ("".equals(seqId) ? "." : StringUtils.protectGFF((String)seqId)) + '\t' + ("".equals(source) ? "." : StringUtils.protectGFF((String)source)) + '\t' + ("".equals(type) ? "." : StringUtils.protectGFF((String)type)) + '\t' + (this.getStart() == -1 ? "." : Integer.valueOf(this.getStart())) + '\t' + (this.getEnd() == -1 ? "." : Integer.valueOf(this.getEnd())) + '\t' + (Double.isNaN(this.getScore()) ? "." : Double.valueOf(this.getScore())) + '\t' + this.getStrand() + '\t' + (this.getPhase() == -1 ? "." : Integer.valueOf(this.getPhase())) + '\t' + this.attributesToGTFString();
    }

    public String toString() {
        return this.toGFF3();
    }

    public int hashCode() {
        return Objects.hash(this.metadata, this.seqId, this.source, this.type, this.start, this.end, this.score, Character.valueOf(this.strand), this.phase, this.attributes);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GFFEntry)) {
            return false;
        }
        GFFEntry that = (GFFEntry)o;
        return Objects.equals(this.metadata, that.metadata) && Objects.equals(this.seqId, that.seqId) && Objects.equals(this.source, that.source) && Objects.equals(this.type, that.type) && this.start == that.start && this.end == that.end && Objects.equals(this.score, that.score) && this.strand == that.strand && this.phase == that.phase && Objects.equals(this.attributes, that.attributes);
    }

    public GFFEntry() {
        this(new EntryMetadata());
    }

    public GFFEntry(EntryMetadata metadata) {
        Objects.requireNonNull(metadata, " metadata argument cannot  be null");
        this.metadata = metadata;
        this.clear();
    }
}

