/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.bio.GenomicInterval;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public class GenomicArray<T>
implements Serializable {
    private static final long serialVersionUID = 539825064205425262L;
    private final Map<String, ChromosomeZones<T>> chromosomes = new HashMap<String, ChromosomeZones<T>>();

    public void addEntry(GenomicInterval interval, T value) {
        if (interval == null) {
            throw new NullPointerException("interval argument cannot be null");
        }
        if (value == null) {
            throw new NullPointerException("value argument cannot be null");
        }
        String chromosomeName = interval.getChromosome();
        if (!this.chromosomes.containsKey(chromosomeName)) {
            this.addChromosome(chromosomeName);
        }
        this.chromosomes.get(chromosomeName).addEntry(interval, value);
    }

    public void addChromosome(String chromosomeName) {
        if (chromosomeName == null) {
            throw new NullPointerException("chromosomeName argument cannot be null");
        }
        if (this.containsChromosome(chromosomeName)) {
            return;
        }
        this.chromosomes.put(chromosomeName, new ChromosomeZones(chromosomeName));
    }

    public void addChromosomes(GenomeDescription gd) {
        if (gd == null) {
            throw new NullPointerException("gd argument cannot be null");
        }
        for (String chromosomeName : gd.getSequencesNames()) {
            this.addChromosome(chromosomeName);
        }
    }

    public Map<GenomicInterval, Set<T>> getEntries(GenomicInterval interval) {
        if (interval == null) {
            throw new NullPointerException("interval argument cannot be null");
        }
        return this.getEntries(interval.getChromosome(), interval.getStart(), interval.getEnd());
    }

    public Map<GenomicInterval, Set<T>> getEntries(String chromosome, int start, int end) {
        if (chromosome == null) {
            throw new NullPointerException("chromosome argument cannot be null");
        }
        ChromosomeZones<T> chr = this.chromosomes.get(chromosome);
        if (chr == null) {
            return null;
        }
        return chr.getEntries(start, end);
    }

    public boolean containsChromosome(String chromosomeName) {
        if (chromosomeName == null) {
            return false;
        }
        return this.chromosomes.containsKey(chromosomeName);
    }

    public Set<String> getFeaturesIds() {
        TreeSet<String> results = new TreeSet<String>();
        for (Map.Entry<String, ChromosomeZones<T>> strandedZone : this.chromosomes.entrySet()) {
            for (Zone zone : ((ChromosomeZones)strandedZone.getValue()).plus.zones) {
                if (zone.valueCount == 0) continue;
                for (Object value : zone.getValues()) {
                    results.add(String.valueOf(value));
                }
            }
            for (Zone zone : ((ChromosomeZones)strandedZone.getValue()).minus.zones) {
                if (zone.valueCount == 0) continue;
                for (Object value : zone.getValues()) {
                    results.add(String.valueOf(value));
                }
            }
        }
        return results;
    }

    public Set<String> getChromosomesNames() {
        return Collections.unmodifiableSet(this.chromosomes.keySet());
    }

    public void clear() {
        this.chromosomes.clear();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenomicArray)) {
            return false;
        }
        GenomicArray that = (GenomicArray)o;
        return Objects.equals(this.chromosomes, that.chromosomes);
    }

    public int hashCode() {
        return Objects.hash(this.chromosomes);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{chromosomes=" + this.chromosomes + "}";
    }

    public GenomicArray() {
    }

    public GenomicArray(GenomeDescription gd) {
        this();
        this.addChromosomes(gd);
    }

    private static final class ChromosomeZones<T>
    implements Serializable {
        private static final long serialVersionUID = -6312870823086177216L;
        private final ChromosomeStrandedZones<T> plus;
        private final ChromosomeStrandedZones<T> minus;

        public void addEntry(GenomicInterval interval, T value) {
            if (interval == null) {
                throw new NullPointerException("interval argument cannot be null");
            }
            if (value == null) {
                throw new NullPointerException("value argument cannot be null");
            }
            if (interval.getStrand() == '+' || interval.getStrand() == '.') {
                this.plus.addEntry(interval, value);
            } else if (interval.getStrand() == '-') {
                this.minus.addEntry(interval, value);
            }
        }

        public Map<GenomicInterval, Set<T>> getEntries(int start, int stop) {
            Map<GenomicInterval, Set<T>> interMinus;
            HashMap<GenomicInterval, Set<T>> result = new HashMap<GenomicInterval, Set<T>>();
            Map<GenomicInterval, Set<T>> interPlus = this.plus.getEntries(start, stop);
            if (interPlus != null) {
                result.putAll(interPlus);
            }
            if ((interMinus = this.minus.getEntries(start, stop)) != null) {
                result.putAll(interMinus);
            }
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChromosomeZones)) {
                return false;
            }
            ChromosomeZones that = (ChromosomeZones)o;
            return Objects.equals(this.minus, that.minus) && Objects.equals(this.plus, that.plus);
        }

        public int hashCode() {
            return Objects.hash(this.minus, this.plus);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{minus=" + this.minus + ", plus=" + this.plus + "}";
        }

        public ChromosomeZones(String chromosomeName) {
            if (chromosomeName == null) {
                throw new NullPointerException("chromosomeName argument cannot be null");
            }
            this.plus = new ChromosomeStrandedZones(chromosomeName);
            this.minus = new ChromosomeStrandedZones(chromosomeName);
        }
    }

    private static final class ChromosomeStrandedZones<T>
    implements Serializable {
        private static final long serialVersionUID = 8073207058699194059L;
        private final String chromosomeName;
        private int length = 0;
        private final List<Zone<T>> zones = new ArrayList<Zone<T>>();

        private Zone<T> get(int index) {
            return this.zones.get(index);
        }

        private void add(Zone<T> zone) {
            this.zones.add(zone);
        }

        private void add(int index, Zone<T> zone) {
            this.zones.add(index, zone);
        }

        private int findIndexPos(int pos) {
            if (pos < 1 || pos > this.length) {
                return -1;
            }
            int minIndex = 0;
            int maxIndex = this.zones.size() - 1;
            int index = 0;
            while (true) {
                Zone<T> z;
                int comp;
                int diff = maxIndex - minIndex;
                index = minIndex + diff / 2;
                if (diff == 1) {
                    if (this.get(minIndex).compareTo(pos) == 0) {
                        return minIndex;
                    }
                    if (this.get(maxIndex).compareTo(pos) == 0) {
                        return maxIndex;
                    }
                    assert (false);
                }
                if ((comp = (z = this.get(index)).compareTo(pos)) == 0) {
                    return index;
                }
                if (comp < 0) {
                    maxIndex = index;
                    continue;
                }
                minIndex = index;
            }
        }

        private Zone<T> splitZone(Zone<T> zone, int pos) {
            Zone<T> result = new Zone<T>(pos, ((Zone)zone).end, ((Zone)zone).strand, zone.getValues());
            ((Zone)zone).end = pos - 1;
            return result;
        }

        public void addEntry(GenomicInterval interval, T value) {
            int count1b;
            Zone<T> z1b;
            if (interval == null) {
                throw new NullPointerException("interval argument cannot be null");
            }
            if (value == null) {
                throw new NullPointerException("value argument cannot be null");
            }
            int intervalStart = interval.getStart();
            int intervalEnd = interval.getEnd();
            if (intervalEnd > this.length) {
                this.add(new Zone(this.length + 1, intervalEnd, interval.getStrand()));
                this.length = intervalEnd;
            }
            int indexStart = this.findIndexPos(intervalStart);
            int indexEnd = this.findIndexPos(intervalEnd);
            Zone<T> z1 = this.get(indexStart);
            if (((Zone)z1).start == intervalStart) {
                z1b = z1;
                count1b = 0;
            } else {
                z1b = this.splitZone(z1, intervalStart);
                count1b = 1;
            }
            if (indexStart == indexEnd) {
                if (((Zone)z1b).end == intervalEnd) {
                    z1b.addExon(value);
                } else {
                    Zone<T> z1c = this.splitZone(z1b, intervalEnd + 1);
                    this.add(indexStart + 1, z1c);
                }
                if (z1 != z1b) {
                    z1b.addExon(value);
                    this.add(indexStart + 1, z1b);
                } else {
                    z1.addExon(value);
                }
            } else {
                Zone<T> z2 = this.get(indexEnd);
                Zone<T> z2b = ((Zone)z2).end != intervalEnd ? this.splitZone(z2, intervalEnd + 1) : z2;
                if (z1 != z1b) {
                    this.add(indexStart + 1, z1b);
                }
                if (z2 != z2b) {
                    this.add(indexEnd + 1 + count1b, z2b);
                }
                for (int i = indexStart + count1b; i <= indexEnd + count1b; ++i) {
                    this.get(i).addExon(value);
                }
            }
        }

        public Map<GenomicInterval, Set<T>> getEntries(int start, int stop) {
            int indexStart = this.findIndexPos(start);
            int indexEnd = this.findIndexPos(stop);
            if (indexStart == -1) {
                return null;
            }
            int to = indexEnd == -1 ? this.zones.size() - 1 : indexEnd;
            HashMap<GenomicInterval, Set<Object>> result = null;
            for (int i = indexStart; i <= to; ++i) {
                Zone<T> zone = this.get(i);
                if (!ChromosomeStrandedZones.intersect(start, stop, ((Zone)zone).start, ((Zone)zone).end)) continue;
                GenomicInterval iv = new GenomicInterval(this.chromosomeName, ((Zone)zone).start, ((Zone)zone).end, ((Zone)zone).strand);
                Set<T> r = zone.getValues();
                if (result == null) {
                    result = new HashMap<GenomicInterval, Set<Object>>();
                }
                if (r != null) {
                    result.put(iv, Collections.unmodifiableSet(r));
                    continue;
                }
                result.put(iv, new HashSet());
            }
            if (stop > ((Zone)this.get(to)).end && start > ((Zone)this.get(to)).start) {
                result.put(new GenomicInterval(this.chromosomeName, start, stop, ((Zone)this.get(to)).strand), new HashSet());
            } else if (stop > ((Zone)this.get(to)).end) {
                result.put(new GenomicInterval(this.chromosomeName, ((Zone)this.get(to)).end + 1, stop, ((Zone)this.get(to)).strand), new HashSet());
            }
            return result;
        }

        private static boolean intersect(int start, int end, int startZone, int endZone) {
            return start >= startZone && start <= endZone || end >= startZone && end <= endZone || start < startZone && end > endZone;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ChromosomeStrandedZones)) {
                return false;
            }
            ChromosomeStrandedZones that = (ChromosomeStrandedZones)o;
            return Objects.equals(this.chromosomeName, that.chromosomeName) && Objects.equals(this.length, that.length) && Objects.equals(this.zones, that.zones);
        }

        public int hashCode() {
            return Objects.hash(this.chromosomeName, this.length, this.zones);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{chromosomeName=" + this.chromosomeName + ", length=" + this.length + ", zones=" + this.zones + "}";
        }

        public ChromosomeStrandedZones(String chromosomeName) {
            if (chromosomeName == null) {
                throw new NullPointerException("chromosomeName argument cannot be null");
            }
            this.chromosomeName = chromosomeName;
        }
    }

    private static final class Zone<T>
    implements Serializable {
        private static final long serialVersionUID = 3581472137861260840L;
        private final int start;
        private int end;
        private final char strand;
        private Set<T> _values;
        private T _value;
        private int valueCount;

        public void addExon(T value) {
            if (value == null) {
                throw new NullPointerException("value argument cannot be null");
            }
            if (this.valueCount == 0) {
                this._value = value;
                this.valueCount = 1;
            } else {
                if (this.valueCount == 1) {
                    if (value == this._value || this._value.hashCode() == value.hashCode()) {
                        return;
                    }
                    this._values = new HashSet<T>();
                    this._values.add(this._value);
                    this._value = null;
                }
                this._values.add(value);
                this.valueCount = this._values.size();
            }
        }

        private void addExons(Set<T> values) {
            if (values == null) {
                return;
            }
            int len = values.size();
            if (len == 0) {
                return;
            }
            if (len == 1) {
                this._value = values.iterator().next();
                this.valueCount = this._value == null ? 0 : 1;
            } else {
                this._values = new HashSet<T>(values);
                this.valueCount = len;
            }
        }

        public Set<T> getValues() {
            if (this.valueCount == 0) {
                return null;
            }
            if (this.valueCount == 1) {
                return Collections.singleton(this._value);
            }
            return this._values;
        }

        public int compareTo(int position) {
            if (position >= this.start && position <= this.end) {
                return 0;
            }
            return position < this.start ? -1 : 1;
        }

        public String toString() {
            HashSet<String> r = new HashSet<String>();
            if (this.getValues() != null) {
                for (T e : this.getValues()) {
                    r.add(e.toString());
                }
            }
            return this.getClass().getSimpleName() + "{" + this.start + "," + this.end + "," + r + "}";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Zone)) {
                return false;
            }
            Zone that = (Zone)o;
            if (!(Objects.equals(this.valueCount, that.valueCount) && Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end) && Objects.equals(Character.valueOf(this.strand), Character.valueOf(that.strand)))) {
                return false;
            }
            switch (this.valueCount) {
                case 0: {
                    return true;
                }
                case 1: {
                    return Objects.equals(this._value, that._value);
                }
            }
            return Objects.equals(this._values, that._values);
        }

        public int hashCode() {
            return Objects.hash(this._value, this._values, this.start, this.end, Character.valueOf(this.strand), this.valueCount);
        }

        public Zone(int start, int end, char strand) {
            this.start = start;
            this.end = end;
            this.strand = strand;
        }

        public Zone(int start, int end, char strand, Set<T> exons) {
            this(start, end, strand);
            super.addExons(exons);
        }
    }
}

