/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.Sequence;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class IlluminaReadId {
    private static final Pattern PATTERN_1 = Pattern.compile("^([a-zA-Z0-9\\-\\_]+):(\\d+):(\\d+):(\\d+):(\\d+)$");
    private static final Pattern PATTERN_2 = Pattern.compile("^([a-zA-Z0-9\\-\\_]+):(\\d+):(\\d+):(\\d+):(\\d+)/(\\d)$");
    private static final Pattern PATTERN_1_4 = Pattern.compile("^([a-zA-Z0-9\\-\\_]+):(\\d+):(\\d+):(\\d+):(\\d+)#([0ATGC]+)/(\\d)$");
    private static final Pattern PATTERN_1_8 = Pattern.compile("^([a-zA-Z0-9\\-\\_]+):(\\d+):([a-zA-Z0-9]+):(\\d+):(\\d+):(\\d+):(\\d+) (\\d+):([YN]):(\\d+):([NATGC\\+]*)$");
    private static final Pattern PATTERN_3 = Pattern.compile("^([a-zA-Z0-9\\-\\_]+):(\\d+):([a-zA-Z0-9]+):(\\d+):(\\d+):(\\d+):(\\d+) (\\d+):([YN]):(\\d+):(\\d)$");
    private static final Pattern PATTERN_SRA = Pattern.compile("^[a-zA-Z0-9\\.]+ ([a-zA-Z0-9\\-\\_]+):(\\d+):([a-zA-Z0-9]+):(\\d+):(\\d+):(\\d+):(\\d+) .*$");
    private static final Pattern SEQUENCE_INDEX_SPLITTER_PATTERN = Pattern.compile("\\+");
    private static final String NO_SEQUENCE_INDEX = "0";
    private final Pattern pattern;
    private String instrumentId;
    private int runId;
    private String flowCellId;
    private int flowCellLane;
    private int tileNumberInFlowCellLane;
    private int xClusterCoordinateInTile;
    private int yClusterCoordinateInTile;
    private String sequenceIndex;
    private int pairMember;
    private boolean filtered;
    private int controlNumber;

    public final String getInstrumentId() {
        return this.instrumentId;
    }

    public final int getRunId() {
        return this.runId;
    }

    public final String getFlowCellId() {
        return this.flowCellId;
    }

    public final int getFlowCellLane() {
        return this.flowCellLane;
    }

    public final int getTileNumberInFlowCellLane() {
        return this.tileNumberInFlowCellLane;
    }

    public final int getXClusterCoordinateInTile() {
        return this.xClusterCoordinateInTile;
    }

    public final int getYClusterCoordinateInTile() {
        return this.yClusterCoordinateInTile;
    }

    public final String getSequenceIndex() {
        return this.sequenceIndex;
    }

    public final List<String> getSequenceIndexList() {
        if (NO_SEQUENCE_INDEX.equals(this.sequenceIndex)) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Arrays.asList(SEQUENCE_INDEX_SPLITTER_PATTERN.split(this.sequenceIndex)));
    }

    public final int getPairMember() {
        return this.pairMember;
    }

    public final boolean isFiltered() {
        return this.filtered;
    }

    public final int getControlNumber() {
        return this.controlNumber;
    }

    public final boolean isInstrumentIdField() {
        return true;
    }

    public final boolean isRunIdField() {
        return this.pattern != PATTERN_1_4 && this.pattern != PATTERN_2 && this.pattern != PATTERN_1;
    }

    public final boolean isFlowCellIdField() {
        return this.pattern != PATTERN_1_4 && this.pattern != PATTERN_2 && this.pattern != PATTERN_1;
    }

    public final boolean isFlowCellLaneField() {
        return true;
    }

    public final boolean isTileNumberInFlowCellLaneField() {
        return true;
    }

    public final boolean isXClusterCoordinateInTileField() {
        return true;
    }

    public final boolean isYClusterCoordinateInTileField() {
        return true;
    }

    public final boolean isSequenceIndexField() {
        return this.pattern != PATTERN_3 && this.pattern != PATTERN_2 && this.pattern != PATTERN_1 && this.pattern != PATTERN_SRA;
    }

    public final boolean isPairMemberField() {
        return this.pattern != PATTERN_1 && this.pattern != PATTERN_SRA;
    }

    public final boolean isFilteredField() {
        return this.pattern != PATTERN_1_4 && this.pattern != PATTERN_2 && this.pattern != PATTERN_1 && this.pattern != PATTERN_SRA;
    }

    public final boolean isControlNumberField() {
        return this.pattern != PATTERN_1_4 && this.pattern != PATTERN_2 && this.pattern != PATTERN_1 && this.pattern != PATTERN_SRA;
    }

    private static Pattern findPattern(String readId) throws KenetreException {
        if (PATTERN_1_8.matcher(readId).lookingAt()) {
            return PATTERN_1_8;
        }
        if (PATTERN_3.matcher(readId).lookingAt()) {
            return PATTERN_3;
        }
        if (PATTERN_1_4.matcher(readId).lookingAt()) {
            return PATTERN_1_4;
        }
        if (PATTERN_2.matcher(readId).lookingAt()) {
            return PATTERN_2;
        }
        if (PATTERN_1.matcher(readId).lookingAt()) {
            return PATTERN_1;
        }
        if (PATTERN_SRA.matcher(readId).lookingAt()) {
            return PATTERN_SRA;
        }
        throw new KenetreException("Invalid illumina id: " + readId);
    }

    public final void parse(Sequence sequence) throws KenetreException {
        if (sequence == null) {
            throw new NullPointerException("The sequence is null");
        }
        this.parse(sequence.getName());
    }

    public final void parse(String readId) throws KenetreException {
        if (readId == null) {
            throw new NullPointerException("The string to parse is null");
        }
        Matcher matcher = this.pattern.matcher(readId.trim());
        if (!matcher.lookingAt()) {
            throw new KenetreException("Invalid illumina id: " + readId);
        }
        if (this.pattern == PATTERN_1_8) {
            this.instrumentId = matcher.group(1);
            this.runId = Integer.parseInt(matcher.group(2));
            this.flowCellId = matcher.group(3);
            this.flowCellLane = Integer.parseInt(matcher.group(4));
            this.tileNumberInFlowCellLane = Integer.parseInt(matcher.group(5));
            this.xClusterCoordinateInTile = Integer.parseInt(matcher.group(6));
            this.yClusterCoordinateInTile = Integer.parseInt(matcher.group(7));
            this.pairMember = Integer.parseInt(matcher.group(8));
            this.filtered = matcher.group(9).charAt(0) == 'Y';
            this.controlNumber = Integer.parseInt(matcher.group(10));
            this.sequenceIndex = matcher.group(11);
            return;
        }
        if (this.pattern == PATTERN_3) {
            this.instrumentId = matcher.group(1);
            this.runId = Integer.parseInt(matcher.group(2));
            this.flowCellId = matcher.group(3);
            this.flowCellLane = Integer.parseInt(matcher.group(4));
            this.tileNumberInFlowCellLane = Integer.parseInt(matcher.group(5));
            this.xClusterCoordinateInTile = Integer.parseInt(matcher.group(6));
            this.yClusterCoordinateInTile = Integer.parseInt(matcher.group(7));
            this.pairMember = Integer.parseInt(matcher.group(8));
            this.filtered = matcher.group(9).charAt(0) == 'Y';
            this.controlNumber = Integer.parseInt(matcher.group(10));
            this.sequenceIndex = NO_SEQUENCE_INDEX;
            return;
        }
        if (this.pattern == PATTERN_1_4) {
            this.instrumentId = matcher.group(1);
            this.runId = -1;
            this.flowCellId = null;
            this.flowCellLane = Integer.parseInt(matcher.group(2));
            this.tileNumberInFlowCellLane = Integer.parseInt(matcher.group(3));
            this.xClusterCoordinateInTile = Integer.parseInt(matcher.group(4));
            this.yClusterCoordinateInTile = Integer.parseInt(matcher.group(5));
            this.sequenceIndex = matcher.group(6);
            this.pairMember = Integer.parseInt(matcher.group(7));
            this.filtered = false;
            this.controlNumber = -1;
            return;
        }
        if (this.pattern == PATTERN_2) {
            this.instrumentId = matcher.group(1);
            this.runId = -1;
            this.flowCellId = null;
            this.flowCellLane = Integer.parseInt(matcher.group(2));
            this.tileNumberInFlowCellLane = Integer.parseInt(matcher.group(3));
            this.xClusterCoordinateInTile = Integer.parseInt(matcher.group(4));
            this.yClusterCoordinateInTile = Integer.parseInt(matcher.group(5));
            this.sequenceIndex = NO_SEQUENCE_INDEX;
            this.pairMember = Integer.parseInt(matcher.group(6));
            this.filtered = false;
            this.controlNumber = -1;
            return;
        }
        if (this.pattern == PATTERN_SRA) {
            this.instrumentId = matcher.group(1);
            this.runId = Integer.parseInt(matcher.group(2));
            this.flowCellId = matcher.group(3);
            this.flowCellLane = Integer.parseInt(matcher.group(4));
            this.tileNumberInFlowCellLane = Integer.parseInt(matcher.group(5));
            this.xClusterCoordinateInTile = Integer.parseInt(matcher.group(6));
            this.yClusterCoordinateInTile = Integer.parseInt(matcher.group(7));
            this.sequenceIndex = NO_SEQUENCE_INDEX;
            this.pairMember = -1;
            this.filtered = false;
            this.controlNumber = -1;
            return;
        }
        this.instrumentId = matcher.group(1);
        this.runId = -1;
        this.flowCellId = null;
        this.flowCellLane = Integer.parseInt(matcher.group(2));
        this.tileNumberInFlowCellLane = Integer.parseInt(matcher.group(3));
        this.xClusterCoordinateInTile = Integer.parseInt(matcher.group(4));
        this.yClusterCoordinateInTile = Integer.parseInt(matcher.group(5));
        this.sequenceIndex = NO_SEQUENCE_INDEX;
        this.pairMember = -1;
        this.filtered = false;
        this.controlNumber = -1;
    }

    public IlluminaReadId(String readId) throws KenetreException {
        if (readId == null) {
            throw new NullPointerException("The string to parse is null");
        }
        this.pattern = IlluminaReadId.findPattern(readId);
        this.parse(readId);
    }

    public IlluminaReadId(Sequence sequence) throws KenetreException {
        if (sequence == null) {
            throw new NullPointerException("The sequence is null");
        }
        String readId = sequence.getName();
        if (readId == null) {
            throw new NullPointerException("The string to parse is null");
        }
        this.pattern = IlluminaReadId.findPattern(readId);
        this.parse(readId);
    }
}

