/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

public class MeltingTemp {
    private static final float R = 1.987f;

    public static float tmstalucDNA(String s, float dnac, float saltc) {
        float dh = 0.0f;
        float ds = 0.0f;
        String sup = s.toUpperCase();
        float[] tcRes = MeltingTemp.tercorrDNA(sup, ds, dh);
        float vs = tcRes[0];
        float vh = tcRes[1];
        vh = vh + (float)MeltingTemp.overcount(sup, "AA") * 7.9f + (float)MeltingTemp.overcount(sup, "TT") * 7.9f + (float)MeltingTemp.overcount(sup, "AT") * 7.2f + (float)MeltingTemp.overcount(sup, "TA") * 7.2f + (float)MeltingTemp.overcount(sup, "CA") * 8.5f + (float)MeltingTemp.overcount(sup, "TG") * 8.5f + (float)MeltingTemp.overcount(sup, "GT") * 8.4f + (float)MeltingTemp.overcount(sup, "AC") * 8.4f;
        vh = vh + (float)MeltingTemp.overcount(sup, "CT") * 7.8f + (float)MeltingTemp.overcount(sup, "AG") * 7.8f + (float)MeltingTemp.overcount(sup, "GA") * 8.2f + (float)MeltingTemp.overcount(sup, "TC") * 8.2f;
        vh = vh + (float)MeltingTemp.overcount(sup, "CG") * 10.6f + (float)MeltingTemp.overcount(sup, "GC") * 9.8f + (float)MeltingTemp.overcount(sup, "GG") * 8.0f + (float)MeltingTemp.overcount(sup, "CC") * 8.0f;
        vs = vs + (float)MeltingTemp.overcount(sup, "AA") * 22.2f + (float)MeltingTemp.overcount(sup, "TT") * 22.2f + (float)MeltingTemp.overcount(sup, "AT") * 20.4f + (float)MeltingTemp.overcount(sup, "TA") * 21.3f;
        vs = vs + (float)MeltingTemp.overcount(sup, "CA") * 22.7f + (float)MeltingTemp.overcount(sup, "TG") * 22.7f + (float)MeltingTemp.overcount(sup, "GT") * 22.4f + (float)MeltingTemp.overcount(sup, "AC") * 22.4f;
        vs = vs + (float)MeltingTemp.overcount(sup, "CT") * 21.0f + (float)MeltingTemp.overcount(sup, "AG") * 21.0f + (float)MeltingTemp.overcount(sup, "GA") * 22.2f + (float)MeltingTemp.overcount(sup, "TC") * 22.2f;
        ds = vs = vs + (float)MeltingTemp.overcount(sup, "CG") * 27.2f + (float)MeltingTemp.overcount(sup, "GC") * 24.4f + (float)MeltingTemp.overcount(sup, "GG") * 19.9f + (float)MeltingTemp.overcount(sup, "CC") * 19.9f;
        dh = vh;
        float k = dnac / 4.0f * 1.0E-9f;
        return 1000.0f * -dh / (-(ds -= 0.368f * ((float)s.length() - 1.0f) * (float)Math.log(saltc / 1000.0f)) + 1.987f * (float)Math.log(k)) - 273.15f;
    }

    public static float tmstalucRNA(String s, int dnac, int saltc) {
        float dh = 0.0f;
        float ds = 0.0f;
        String sup = s.toUpperCase();
        float[] tcRes = MeltingTemp.tercorrRNA(sup, ds, dh);
        float vs = tcRes[0];
        float vh = tcRes[1];
        vh = vh + (float)MeltingTemp.overcount(sup, "AA") * 6.82f + (float)MeltingTemp.overcount(sup, "TT") * 6.6f + (float)MeltingTemp.overcount(sup, "AT") * 9.38f + (float)MeltingTemp.overcount(sup, "TA") * 7.69f + (float)MeltingTemp.overcount(sup, "CA") * 10.44f + (float)MeltingTemp.overcount(sup, "TG") * 10.5f + (float)MeltingTemp.overcount(sup, "GT") * 11.4f + (float)MeltingTemp.overcount(sup, "AC") * 10.2f;
        vh = vh + (float)MeltingTemp.overcount(sup, "CT") * 10.48f + (float)MeltingTemp.overcount(sup, "AG") * 7.6f + (float)MeltingTemp.overcount(sup, "GA") * 12.44f + (float)MeltingTemp.overcount(sup, "TC") * 13.3f;
        vh = vh + (float)MeltingTemp.overcount(sup, "CG") * 10.64f + (float)MeltingTemp.overcount(sup, "GC") * 14.88f + (float)MeltingTemp.overcount(sup, "GG") * 13.39f + (float)MeltingTemp.overcount(sup, "CC") * 12.2f;
        vs = vs + (float)MeltingTemp.overcount(sup, "AA") * 19.0f + (float)MeltingTemp.overcount(sup, "TT") * 18.4f + (float)MeltingTemp.overcount(sup, "AT") * 26.7f + (float)MeltingTemp.overcount(sup, "TA") * 20.5f;
        vs = vs + (float)MeltingTemp.overcount(sup, "CA") * 26.9f + (float)MeltingTemp.overcount(sup, "TG") * 27.8f + (float)MeltingTemp.overcount(sup, "GT") * 29.5f + (float)MeltingTemp.overcount(sup, "AC") * 26.2f;
        vs = vs + (float)MeltingTemp.overcount(sup, "CT") * 27.1f + (float)MeltingTemp.overcount(sup, "AG") * 19.2f + (float)MeltingTemp.overcount(sup, "GA") * 32.5f + (float)MeltingTemp.overcount(sup, "TC") * 35.5f;
        ds = vs = vs + (float)MeltingTemp.overcount(sup, "CG") * 26.7f + (float)MeltingTemp.overcount(sup, "GC") * 36.9f + (float)MeltingTemp.overcount(sup, "GG") * 32.7f + (float)MeltingTemp.overcount(sup, "CC") * 29.7f;
        dh = vh;
        float k = (float)dnac / 4.0f * 1.0E-9f;
        return 1000.0f * -dh / (-(ds -= 0.368f * ((float)s.length() - 1.0f) * (float)Math.log((float)saltc / 1000.0f)) + 1.987f * (float)Math.log(k)) - 273.15f;
    }

    private static float[] tercorrDNA(String stri, float ds, float dh) {
        float deltah = 0.0f;
        float deltas = 0.0f;
        if (stri.startsWith("G") || stri.startsWith("C")) {
            deltah -= 0.1f;
            deltas += 2.8f;
        } else if (stri.startsWith("A") || stri.startsWith("T")) {
            deltah -= 2.3f;
            deltas -= 4.1f;
        }
        if (stri.endsWith("G") || stri.endsWith("C")) {
            deltah -= 0.1f;
            deltas += 2.8f;
        } else if (stri.endsWith("A") || stri.endsWith("T")) {
            deltah -= 2.3f;
            deltas -= 4.1f;
        }
        float dhL = dh + deltah;
        float dsL = ds + deltas;
        return new float[]{dsL, dhL};
    }

    private static float[] tercorrRNA(String stri, float ds, float dh) {
        float deltah = 0.0f;
        float deltas = 0.0f;
        char firstChar = stri.charAt(0);
        if (firstChar == 'G' || firstChar == 'C') {
            deltah -= 3.61f;
            deltas -= 1.5f;
        } else if (firstChar == 'A' || firstChar == 'T' || firstChar == 'U') {
            deltah -= 3.72f;
            deltas += 10.5f;
        }
        if (stri.endsWith("G") || stri.endsWith("C")) {
            deltah -= 3.61f;
            deltas -= 1.5f;
        } else if (stri.endsWith("A") || stri.endsWith("T") || stri.endsWith("U")) {
            deltah -= 3.72f;
            deltas += 10.5f;
        }
        float dhL = dh + deltah;
        float dsL = ds + deltas;
        return new float[]{dsL, dhL};
    }

    private static int overcount(String st, String p) {
        int i;
        int ocu = 0;
        int x = 0;
        while ((i = st.indexOf(p, x)) != -1) {
            ++ocu;
            x = i + 1;
        }
        return ocu;
    }
}

