/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.Sequence;
import java.util.Iterator;

public class NanoporeReadId {
    private final Splitter spaceSplitter = Splitter.on((char)' ').omitEmptyStrings();
    private final Splitter equalsSplitter = Splitter.on((char)'=');
    private String readId;
    private String runId;
    private int readNumber;
    private int channel;
    private String startTime;
    private String barcode;

    public String getReadId() {
        return this.readId;
    }

    public SequenceType getSequenceType() {
        if (this.readId == null) {
            return null;
        }
        if (this.readId.endsWith("_t")) {
            return SequenceType.TEMPLATE;
        }
        if (this.readId.endsWith("_c")) {
            return SequenceType.COMPLEMENT;
        }
        if (this.readId.indexOf(95) == -1) {
            return SequenceType.CONSENSUS;
        }
        return null;
    }

    public String getRunId() {
        return this.runId;
    }

    public int getReadNumber() {
        return this.readNumber;
    }

    public int getChannel() {
        return this.channel;
    }

    public String getStartTime() {
        return this.startTime;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public boolean isBarcoded() {
        return this.barcode != null;
    }

    public void parse(String readId) {
        if (readId == null) {
            throw new NullPointerException("The string to parse is null");
        }
        this.readId = null;
        this.runId = null;
        this.readNumber = -1;
        this.channel = -1;
        this.startTime = null;
        this.barcode = null;
        boolean first = true;
        for (String s : this.spaceSplitter.split((CharSequence)readId)) {
            if (first) {
                this.readId = s;
                first = false;
                continue;
            }
            Iterator it = this.equalsSplitter.split((CharSequence)s).iterator();
            if (!it.hasNext()) continue;
            String key = (String)it.next();
            if (!it.hasNext()) continue;
            String value = (String)it.next();
            switch (key) {
                case "runid": {
                    this.runId = value;
                    break;
                }
                case "read": {
                    this.readNumber = Integer.parseInt(value);
                    break;
                }
                case "ch": {
                    this.channel = Integer.parseInt(value);
                    break;
                }
                case "start_time": {
                    this.startTime = value;
                    break;
                }
                case "barcode": {
                    this.barcode = value;
                    break;
                }
            }
        }
    }

    public NanoporeReadId(String readId) throws KenetreException {
        if (readId == null) {
            throw new NullPointerException("The string to parse is null");
        }
        this.parse(readId);
    }

    public NanoporeReadId(Sequence sequence) throws KenetreException {
        if (sequence == null) {
            throw new NullPointerException("The sequence is null");
        }
        String readId = sequence.getName();
        if (readId == null) {
            throw new NullPointerException("The string to parse is null");
        }
        this.parse(readId);
    }

    public static enum SequenceType {
        TEMPLATE,
        COMPLEMENT,
        CONSENSUS;

    }
}

