/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.Alphabets;
import fr.ens.biologie.genomique.kenetre.bio.FastqFormat;
import fr.ens.biologie.genomique.kenetre.bio.Sequence;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.util.Objects;

public final class ReadSequence
extends Sequence {
    private FastqFormat fastqFormat = FastqFormat.FASTQ_SANGER;
    private String quality;

    public FastqFormat getFastqFormat() {
        return this.fastqFormat;
    }

    public String getQuality() {
        return this.quality;
    }

    public void setFastqFormat(FastqFormat fastqFormat) {
        if (fastqFormat == null) {
            throw new NullPointerException("The FastqFormat is null");
        }
        this.fastqFormat = fastqFormat;
    }

    public void setQuality(String quality) {
        this.quality = StringUtils.trim((String)quality);
    }

    public void set(ReadSequence rs) {
        if (rs == null) {
            return;
        }
        this.setName(rs.getName());
        this.setSequence(rs.getSequence());
        this.setQuality(rs.getQuality());
        this.setFastqFormat(rs.getFastqFormat());
    }

    public int[] qualityScores() {
        if (this.quality == null) {
            return null;
        }
        char[] qualities = this.quality.toCharArray();
        int len = qualities.length;
        FastqFormat format = this.fastqFormat;
        int[] result = new int[len];
        for (int i = 0; i < len; ++i) {
            result[i] = format.getScore(qualities[i]);
        }
        return result;
    }

    public double[] errorProbabilities() {
        if (this.quality == null) {
            return null;
        }
        char[] qualities = this.quality.toCharArray();
        int len = qualities.length;
        FastqFormat format = this.fastqFormat;
        double[] result = new double[len];
        for (int i = 0; i < len; ++i) {
            result[i] = format.getProbability(qualities[i]);
        }
        return result;
    }

    @Override
    public ReadSequence subSequence(int beginIndex, int endIndex) {
        if (this.sequence == null || this.quality == null || this.sequence.length() != this.quality.length()) {
            return null;
        }
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        ReadSequence result = new ReadSequence(this.name == null ? null : this.name + "[part]", this.sequence.substring(beginIndex, endIndex), this.quality.substring(beginIndex, endIndex));
        result.fastqFormat = this.fastqFormat;
        return result;
    }

    public ReadSequence concat(ReadSequence sequence) {
        ReadSequence result = new ReadSequence();
        result.setName(this.name + "[merged]");
        result.fastqFormat = this.fastqFormat;
        result.alphabet = this.alphabet;
        if (sequence == null) {
            result.sequence = this.sequence;
            result.quality = this.quality;
            return result;
        }
        result.sequence = this.sequence == null ? sequence.sequence : (sequence.sequence == null ? this.sequence : this.sequence + sequence.sequence);
        result.quality = this.quality == null ? sequence.quality : (sequence.quality == null ? this.quality : this.quality + sequence.quality);
        return result;
    }

    @Override
    public void reverse() {
        this.sequence = ReadSequence.reverse(this.sequence);
        this.quality = ReadSequence.reverse(this.quality);
    }

    @Override
    public void reverseComplement() {
        this.sequence = ReadSequence.reverseComplement(this.sequence, this.alphabet);
        this.quality = ReadSequence.reverse(this.quality);
    }

    public String toFastQ() {
        return ReadSequence.toFastQ(this.name, this.sequence, this.quality, false);
    }

    public String toFastQ(boolean repeatId) {
        return ReadSequence.toFastQ(this.name, this.sequence, this.quality, repeatId);
    }

    public static final String toFastQ(String name, String sequence, String quality) {
        return ReadSequence.toFastQ(name, sequence, quality, false);
    }

    public static final String toFastQ(String name, String sequence, String quality, boolean repeatId) {
        if (name == null || sequence == null || quality == null) {
            return null;
        }
        return '@' + name + '\n' + sequence + '\n' + '+' + (repeatId ? name : "") + '\n' + quality;
    }

    public String toTFQ() {
        return this.toTFQ(true);
    }

    public String toTFQ(boolean withId) {
        return ReadSequence.toTFQ(withId, this.name, this.sequence, this.quality);
    }

    public static final String toTFQ(String name, String sequence, String quality) {
        return ReadSequence.toTFQ(true, name, sequence, quality);
    }

    public static final String toTFQ(boolean withId, String name, String sequence, String quality) {
        if (name == null || sequence == null || quality == null) {
            return null;
        }
        if (withId) {
            return name + '\t' + sequence + '\t' + quality;
        }
        return '\t' + sequence + '\t' + quality;
    }

    public String toOutKey() {
        return this.name;
    }

    public String toOutValue() {
        return this.sequence + "\t" + this.quality;
    }

    public void parseFastQ(String fastQ) {
        if (fastQ == null) {
            return;
        }
        int indexCR1 = fastQ.indexOf(10);
        int indexCR2 = fastQ.indexOf(10, indexCR1 + 1);
        int indexCR3 = fastQ.indexOf(10, indexCR2 + 1);
        int indexCR4 = fastQ.indexOf(10, indexCR3 + 1);
        this.name = fastQ.substring(1, indexCR1);
        this.sequence = fastQ.substring(indexCR1 + 1, indexCR2);
        this.quality = indexCR4 == -1 ? fastQ.substring(indexCR3 + 1) : fastQ.substring(indexCR3 + 1, indexCR4);
    }

    public void parse(String s) {
        if (s == null) {
            return;
        }
        int indexTab1 = s.indexOf(9);
        int indexTab2 = s.indexOf(9, indexTab1 + 1);
        this.name = s.substring(0, indexTab1);
        this.sequence = s.substring(indexTab1 + 1, indexTab2);
        this.quality = s.substring(indexTab2 + 1);
    }

    public void parseKeyValue(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.name = key;
        int indexTab = value.indexOf(9);
        this.sequence = value.substring(0, indexTab);
        this.quality = value.substring(indexTab + 1);
    }

    protected boolean validateQuality() {
        String q = this.quality;
        if (q == null) {
            return false;
        }
        int len = q.length();
        if (len == 0 || len != this.length()) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (this.fastqFormat.isCharValid(q.charAt(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean validate() {
        return this.validateName() && this.validateSequence() && this.validateQuality();
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.description, this.alphabet, this.sequence, this.quality, this.fastqFormat});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReadSequence) || !super.equals(o)) {
            return false;
        }
        ReadSequence that = (ReadSequence)o;
        return this.fastqFormat.equals((Object)that.fastqFormat) && Objects.equals(this.quality, that.quality);
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", description=" + this.description + ", alphabet=" + this.alphabet + ", sequence=" + this.sequence + ", fastqFormat=" + (Object)((Object)this.fastqFormat) + ", quality=" + this.quality + "}";
    }

    public ReadSequence() {
        this.alphabet = Alphabets.READ_DNA_ALPHABET;
    }

    public ReadSequence(String name, String sequence, String quality) {
        this(name, sequence, quality, FastqFormat.FASTQ_SANGER);
    }

    public ReadSequence(String name, String sequence, String quality, FastqFormat fastqFormat) {
        super(name, sequence);
        this.quality = quality;
        this.fastqFormat = fastqFormat;
        this.alphabet = Alphabets.READ_DNA_ALPHABET;
    }

    @Deprecated
    public ReadSequence(int id, String name, String sequence, String quality) {
        this(name, sequence, quality);
    }

    @Deprecated
    public ReadSequence(int id, String name, String sequence, String quality, FastqFormat fastqFormat) {
        this(name, sequence, quality, fastqFormat);
    }
}

