/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.Alphabet;
import fr.ens.biologie.genomique.kenetre.bio.Alphabets;
import fr.ens.biologie.genomique.kenetre.bio.MeltingTemp;
import fr.ens.biologie.genomique.kenetre.util.StringUtils;
import java.util.Objects;

public class Sequence {
    protected String name;
    protected String description;
    protected Alphabet alphabet = Alphabets.AMBIGUOUS_DNA_ALPHABET;
    protected String sequence;

    @Deprecated
    public int getId() {
        return -1;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifierInName() {
        if (this.name == null) {
            return null;
        }
        int pos = this.name.indexOf(32);
        if (pos == -1) {
            return this.name;
        }
        return this.name.substring(0, pos);
    }

    public String getDescriptionInName() {
        if (this.name == null) {
            return null;
        }
        int pos = this.name.indexOf(32);
        if (pos == -1) {
            return "";
        }
        return StringUtils.trim((String)this.name.substring(pos));
    }

    public String getDescription() {
        return this.description;
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public String getSequence() {
        return this.sequence;
    }

    @Deprecated
    public void setId(int id) {
    }

    public void setName(String name) {
        this.name = StringUtils.trim((String)name);
    }

    public boolean setNameWithValidation(String name) {
        this.name = StringUtils.trim((String)name);
        return this.validateName();
    }

    public void setDescription(String description) {
        this.description = StringUtils.trim((String)description);
    }

    public void setAlphabet(Alphabet alphabet) {
        if (alphabet == null) {
            throw new NullPointerException("The alphabet is null");
        }
        this.alphabet = alphabet;
    }

    public void setSequence(String sequence) {
        this.sequence = StringUtils.trim((String)sequence);
    }

    public boolean setSequenceWithValidation(String sequence) {
        this.sequence = StringUtils.trim((String)sequence);
        return this.validateSequence();
    }

    public void set(Sequence sequence) {
        if (sequence == null) {
            throw new NullPointerException("Sequence is null");
        }
        this.name = sequence.name;
        this.description = sequence.description;
        this.alphabet = sequence.alphabet;
        this.sequence = sequence.sequence;
    }

    public int length() {
        if (this.sequence == null) {
            return 0;
        }
        return this.sequence.length();
    }

    public Sequence subSequence(int beginIndex, int endIndex) {
        if (this.sequence == null) {
            return null;
        }
        if (beginIndex < 0) {
            throw new StringIndexOutOfBoundsException(beginIndex);
        }
        if (endIndex > this.length()) {
            throw new StringIndexOutOfBoundsException(endIndex);
        }
        if (beginIndex > endIndex) {
            throw new StringIndexOutOfBoundsException(endIndex - beginIndex);
        }
        return new Sequence(this.name == null ? null : this.name + "[part]", this.getSequence().substring(beginIndex, endIndex));
    }

    public Sequence concat(Sequence sequence) {
        if (sequence == null || sequence.getSequence() == null) {
            return new Sequence(this);
        }
        Sequence result = new Sequence();
        result.name = this.name + "[merged]";
        result.alphabet = this.alphabet;
        result.sequence = this.sequence == null ? sequence.sequence : this.sequence + sequence.sequence;
        return result;
    }

    public int countSequence(Sequence sequence) {
        if (sequence == null) {
            return 0;
        }
        return this.countSequence(sequence.getSequence());
    }

    public int countSequence(String s) {
        if (s == null || this.sequence == null || s.length() == 0) {
            return 0;
        }
        int count = 0;
        int index = 0;
        while ((index = this.sequence.indexOf(s, index)) != -1) {
            ++count;
            index += s.length();
        }
        return count;
    }

    public float getTm() {
        return this.getTm(50.0f, 50.0f);
    }

    public float getTm(float dnac, float saltc) {
        return MeltingTemp.tmstalucDNA(this.sequence, dnac, saltc);
    }

    public double getGCPercent() {
        if (this.sequence == null) {
            return Double.NaN;
        }
        int count = 0;
        for (char base : this.sequence.toCharArray()) {
            if (base != 'G' && base != 'C') continue;
            ++count;
        }
        return (double)count / (double)this.sequence.length();
    }

    public void reverse() {
        this.sequence = Sequence.reverse(this.sequence);
    }

    public static String reverse(String sequence) {
        if (sequence == null) {
            return null;
        }
        char[] array = sequence.toCharArray();
        int len = array.length;
        StringBuilder sb = new StringBuilder(len);
        for (int i = len - 1; i >= 0; --i) {
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public void complement() {
        this.sequence = Sequence.complement(this.sequence, this.alphabet);
    }

    public static final String complement(String sequence, Alphabet alphabet) {
        if (sequence == null || alphabet == null) {
            return null;
        }
        char[] array = sequence.toCharArray();
        int len = array.length;
        StringBuilder sb = new StringBuilder(len);
        for (char base : array) {
            sb.append(alphabet.getComplement(base));
        }
        return sb.toString();
    }

    public void reverseComplement() {
        this.sequence = Sequence.reverseComplement(this.sequence, this.alphabet);
    }

    public static final String reverseComplement(String sequence, Alphabet alphabet) {
        if (sequence == null || alphabet == null) {
            return null;
        }
        char[] array = sequence.toCharArray();
        int len = array.length;
        StringBuilder sb = new StringBuilder(len);
        for (int i = len - 1; i >= 0; --i) {
            sb.append(alphabet.getComplement(array[i]));
        }
        return sb.toString();
    }

    public String toFasta() {
        return '>' + (this.name == null ? "" : this.name) + '\n' + (this.sequence == null ? "" : this.sequence);
    }

    public String toFasta(int width) {
        if (width < 1) {
            return this.toFasta();
        }
        StringBuilder sb = new StringBuilder();
        sb.append('>');
        sb.append(this.name);
        sb.append('\n');
        int len = this.sequence.length();
        int pos = 0;
        while (pos < len) {
            int nextPos = pos + width;
            if (nextPos > len) {
                sb.append(this.sequence.subSequence(pos, len));
            } else {
                sb.append(this.sequence.subSequence(pos, nextPos));
                sb.append('\n');
            }
            pos = nextPos;
        }
        return sb.toString();
    }

    public void parseFasta(String s) {
        if (s == null || s.trim().length() == 0) {
            this.setName(null);
            this.setSequence(null);
            return;
        }
        String[] lines = s.split("\n");
        String name = null;
        StringBuilder seq = new StringBuilder();
        boolean first = true;
        for (String line : lines) {
            String trimmed = line.trim();
            if (first) {
                first = false;
                if (!trimmed.startsWith(">")) break;
                name = trimmed.substring(1).trim();
                continue;
            }
            if (trimmed.startsWith(">")) break;
            seq.append(trimmed);
        }
        if (seq.length() > 0) {
            this.setName(name);
            this.setSequence(seq.toString());
        } else {
            this.setName(null);
            this.setSequence(null);
        }
    }

    protected boolean validateName() {
        return this.name != null && this.name.length() > 0;
    }

    protected boolean validateSequence() {
        int len;
        String seq = this.sequence;
        int n = len = seq == null ? 0 : seq.length();
        if (len == 0) {
            return false;
        }
        Alphabet alphabet = this.alphabet;
        char[] array = this.sequence.toCharArray();
        for (int i = 0; i < len; ++i) {
            if (alphabet.isLetterValid(array[i])) continue;
            return false;
        }
        return true;
    }

    public boolean validate() {
        return this.validateName() && this.validateSequence();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.description, this.alphabet, this.sequence);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Sequence)) {
            return false;
        }
        Sequence that = (Sequence)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.description, that.description) && Objects.equals(this.alphabet, that.alphabet) && Objects.equals(this.sequence, that.sequence);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.name + ", description=" + this.description + ", alphabet=" + this.alphabet.toString() + ", sequence=" + this.sequence + "}";
    }

    public Sequence() {
    }

    public Sequence(String name, String sequence) {
        this.name = name;
        this.sequence = sequence;
    }

    public Sequence(String name, String sequence, String description) {
        this.name = name;
        this.sequence = sequence;
        this.description = description;
    }

    @Deprecated
    public Sequence(int id, String name, String sequence) {
        this(name, sequence);
    }

    @Deprecated
    public Sequence(int id, String name, String sequence, String description) {
        this(name, sequence, description);
    }

    public Sequence(Sequence sequence) {
        if (sequence == null) {
            throw new NullPointerException("Sequence is null");
        }
        this.name = sequence.name;
        this.alphabet = sequence.alphabet;
        this.sequence = sequence.sequence;
        this.description = sequence.description;
    }
}

