/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio;

import fr.ens.biologie.genomique.kenetre.bio.AbstractMatrix;
import fr.ens.biologie.genomique.kenetre.bio.Matrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;

public class SparseMatrix<E>
extends AbstractMatrix<E> {
    private final NavigableMap<Long, E> values = new TreeMap<Long, E>();
    private final Map<String, Integer> rowNames = new LinkedHashMap<String, Integer>();
    private final Map<String, Integer> columnNames = new LinkedHashMap<String, Integer>();
    private final Map<Integer, String> reverseRowNames = new HashMap<Integer, String>();
    private final Map<Integer, String> reverseColumnNames = new HashMap<Integer, String>();
    private final Map<Integer, Integer> columnIndex = new HashMap<Integer, Integer>();
    private int rowCount;
    private int columnCount;
    private final E defaultValue;

    @Override
    public List<String> getRowNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.rowNames.keySet()));
    }

    @Override
    public int getRowCount() {
        return this.rowNames.size();
    }

    @Override
    public List<String> getColumnNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.columnNames.keySet()));
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.size();
    }

    @Override
    public List<E> getColumnValues(String columnName) {
        ArrayList<E> result = new ArrayList<E>(this.rowNames.size());
        Integer columnId = this.getColumnId(columnName);
        for (Map.Entry<String, Integer> e : this.rowNames.entrySet()) {
            Long id = SparseMatrix.getCellId(e.getValue(), columnId);
            result.add(this.getValue(id));
        }
        return result;
    }

    @Override
    public List<E> getRowValues(String rowName) {
        int colCount = this.columnNames.size();
        Integer rowId = this.getRowId(rowName);
        ArrayList<E> result = new ArrayList<E>(colCount);
        int i = 0;
        SortedMap<Long, E> subMap = this.values.subMap(SparseMatrix.getCellId(rowId, 0), SparseMatrix.getCellId(rowId + 1, 0));
        if (subMap.isEmpty()) {
            return Collections.nCopies(colCount, this.defaultValue);
        }
        boolean columnRemoved = this.columnCount != this.columnIndex.size();
        for (Map.Entry<Long, E> e : subMap.entrySet()) {
            int pos;
            int entryCol = SparseMatrix.getColumnId(e.getKey());
            int n = pos = columnRemoved ? this.columnIndex.get(entryCol) : entryCol;
            while (i < pos) {
                result.add(this.defaultValue);
                ++i;
            }
            result.add(e.getValue());
            ++i;
        }
        while (i < colCount) {
            result.add(this.defaultValue);
            ++i;
        }
        return result;
    }

    @Override
    public Iterable<Matrix.Entry<E>> nonZeroValues() {
        final Iterator it = this.values.entrySet().iterator();
        return new Iterable<Matrix.Entry<E>>(){

            @Override
            public Iterator<Matrix.Entry<E>> iterator() {
                return new Iterator<Matrix.Entry<E>>(){
                    int lastRowId = -1;
                    String lastRowName;

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("remove");
                    }

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Matrix.Entry<E> next() {
                        Map.Entry e = (Map.Entry)it.next();
                        Long cellId = (Long)e.getKey();
                        int rowId = SparseMatrix.getRowId(cellId);
                        int columnId = SparseMatrix.getColumnId(cellId);
                        if (rowId != this.lastRowId) {
                            this.lastRowId = rowId;
                            this.lastRowName = (String)SparseMatrix.this.reverseRowNames.get(rowId);
                        }
                        return new AbstractMatrix.BasicEntry(this.lastRowName, (String)SparseMatrix.this.reverseColumnNames.get(columnId), e.getValue());
                    }
                };
            }
        };
    }

    @Override
    public E getValue(String rowName, String columnName) {
        return this.getValue(SparseMatrix.getCellId(this.getRowId(rowName), this.getColumnId(columnName)));
    }

    @Override
    public boolean containsColumn(String columnName) {
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        return this.columnNames.containsKey(columnName);
    }

    @Override
    public boolean containsRow(String rowName) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        return this.rowNames.containsKey(rowName);
    }

    @Override
    public void setValue(String rowName, String columnName, E value) {
        Integer columnId;
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        Integer rowId = this.rowNames.get(rowName);
        if (rowId == null) {
            this.addRow(rowName);
            rowId = this.rowCount - 1;
        }
        if ((columnId = this.columnNames.get(columnName)) == null) {
            this.addColumn(columnName);
            columnId = this.columnCount - 1;
        }
        Long cellId = SparseMatrix.getCellId(rowId, columnId);
        this.values.put(cellId, value);
    }

    @Override
    public void addRow(String rowName) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        if (this.rowNames.containsKey(rowName)) {
            return;
        }
        this.rowNames.put(rowName, this.rowCount);
        this.reverseRowNames.put(this.rowCount++, rowName);
    }

    @Override
    public void addColumn(String columnName) {
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        if (this.columnNames.containsKey(columnName)) {
            return;
        }
        this.columnNames.put(columnName, this.columnCount);
        this.reverseColumnNames.put(this.columnCount, columnName);
        this.columnIndex.put(this.columnCount++, this.columnIndex.size());
    }

    @Override
    public void renameColumn(String oldColumnName, String newColumnName) {
        Objects.requireNonNull(oldColumnName, "oldColumnName cannot be null");
        Objects.requireNonNull(newColumnName, "newColumnName cannot be null");
        if (!this.containsColumn(oldColumnName)) {
            throw new IllegalArgumentException("Unknown column name: " + oldColumnName);
        }
        if (this.containsColumn(newColumnName)) {
            throw new IllegalArgumentException("The new column name already exists: " + newColumnName);
        }
        Integer columnId = this.getColumnId(oldColumnName);
        this.columnNames.remove(oldColumnName);
        this.columnNames.put(newColumnName, columnId);
        this.reverseColumnNames.put(columnId, newColumnName);
    }

    @Override
    public void removeColumn(String columnName) {
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        if (!this.columnNames.containsKey(columnName)) {
            throw new IllegalArgumentException("columnName does not exists: " + columnName);
        }
        Integer columnId = this.getColumnId(columnName);
        for (Map.Entry<String, Integer> e : this.rowNames.entrySet()) {
            Integer rowId = e.getValue();
            Long id = SparseMatrix.getCellId(rowId, columnId);
            if (!this.values.containsKey(id)) continue;
            this.values.remove(id);
        }
        this.columnNames.remove(columnName);
        this.reverseColumnNames.remove(columnId);
        this.columnIndex.remove(columnId);
        for (int i = columnId + 1; i < this.columnCount; ++i) {
            if (!this.columnIndex.containsKey(i)) continue;
            this.columnIndex.put(i, this.columnIndex.get(i) - 1);
        }
    }

    @Override
    public void removeRow(String rowName) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        if (!this.rowNames.containsKey(rowName)) {
            throw new IllegalArgumentException("rowName does not exists: " + rowName);
        }
        Integer rowId = this.getRowId(rowName);
        for (Map.Entry<String, Integer> e : this.columnNames.entrySet()) {
            Long id = SparseMatrix.getCellId(rowId, e.getValue());
            if (!this.values.containsKey(id)) continue;
            this.values.remove(id);
        }
        this.rowNames.remove(rowName);
        this.reverseRowNames.remove(rowId);
    }

    @Override
    public E getDefaultValue() {
        return this.defaultValue;
    }

    private Integer getColumnId(String columnName) {
        Objects.requireNonNull(columnName, "columnName argument cannot be null");
        Integer result = this.columnNames.get(columnName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown column name: " + columnName);
        }
        return result;
    }

    private Integer getRowId(String rowName) {
        Objects.requireNonNull(rowName, "rowName argument cannot be null");
        Integer result = this.rowNames.get(rowName);
        if (result == null) {
            throw new IllegalArgumentException("Unknown row name: " + rowName);
        }
        return result;
    }

    private static Long getCellId(Integer rowId, Integer columnId) {
        return (rowId.longValue() << 32) + columnId.longValue();
    }

    private static int getRowId(Long cellId) {
        return (int)(cellId >> 32);
    }

    private static int getColumnId(Long cellId) {
        return cellId.intValue();
    }

    private E getValue(Long id) {
        Object result = this.values.get(id);
        return (E)(result != null ? result : this.defaultValue);
    }

    public SparseMatrix(E defaultValue) {
        this.defaultValue = defaultValue;
    }
}

