/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.AbstractReadAlignmentFilter;
import htsjdk.samtools.SAMRecord;
import java.util.List;

public class GSNAPReadAlignmentFilter
extends AbstractReadAlignmentFilter {
    public static final String FILTER_NAME = "gsnapfilter";

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Remove all GSNAP alignments that are not supported by the expression estimation step";
    }

    @Override
    public void filterReadAlignments(List<SAMRecord> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        if (!records.get(0).getReadPairedFlag()) {
            if (records.size() > 1) {
                records.clear();
            }
        } else if (records.size() > 2) {
            records.clear();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + "}";
    }
}

