/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.AbstractReadAlignmentFilter;
import htsjdk.samtools.SAMRecord;
import java.util.List;

public class KeepOneMatchReadAlignmentFilter
extends AbstractReadAlignmentFilter {
    public static final String FILTER_NAME = "keeponematch";

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "After this filter only one alignment is kept by read";
    }

    @Override
    public void filterReadAlignments(List<SAMRecord> records) {
        if (records == null || records.isEmpty()) {
            return;
        }
        if (!records.get(0).getReadPairedFlag()) {
            if (records.size() < 2) {
                return;
            }
            SAMRecord first = records.get(0);
            records.clear();
            records.add(first);
        } else {
            if (records.size() < 4) {
                return;
            }
            SAMRecord first = records.get(0);
            SAMRecord second = records.get(1);
            records.clear();
            records.add(first);
            records.add(second);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + "}";
    }
}

