/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.alignmentfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.alignmentfilter.AbstractReadAlignmentFilter;
import htsjdk.samtools.SAMRecord;
import java.util.ArrayList;
import java.util.List;

public class QualityReadAlignmentFilter
extends AbstractReadAlignmentFilter {
    public static final String FILTER_NAME = "quality";
    private int qualityThreshold = -1;
    private final List<SAMRecord> result = new ArrayList<SAMRecord>();

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "With this filter, the alignments are filtered by their quality score.";
    }

    @Override
    public void filterReadAlignments(List<SAMRecord> records) {
        if (records == null) {
            return;
        }
        if (!records.get(0).getReadPairedFlag()) {
            for (SAMRecord r : records) {
                if (r.getMappingQuality() >= this.qualityThreshold) continue;
                this.result.add(r);
            }
        } else {
            for (int counterRecord = 0; counterRecord < records.size() - 1; counterRecord += 2) {
                if (records.get(counterRecord).getMappingQuality() >= this.qualityThreshold && records.get(counterRecord + 1).getMappingQuality() >= this.qualityThreshold) continue;
                this.result.add(records.get(counterRecord));
                this.result.add(records.get(counterRecord + 1));
            }
        }
        records.removeAll(this.result);
        this.result.clear();
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("threshold".equals(key.trim())) {
            try {
                this.qualityThreshold = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (this.qualityThreshold < 0 || this.qualityThreshold > 255) {
                throw new KenetreException("Invalid qualityThreshold: " + this.qualityThreshold);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " alignments filter: " + key);
        }
    }

    @Override
    public void init() {
        if (this.qualityThreshold < 0) {
            throw new IllegalArgumentException("Quality threshold is not set for " + this.getName() + " alignments filter.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name=" + this.getName() + ", qualityThreshold=" + this.qualityThreshold + "}";
    }
}

