/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.BEDEntry;
import fr.ens.biologie.genomique.kenetre.bio.BadBioEntryException;
import fr.ens.biologie.genomique.kenetre.bio.EntryMetadata;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class BEDReader
implements Iterator<BEDEntry>,
Iterable<BEDEntry>,
Closeable {
    private final BufferedReader reader;
    private BEDEntry result = null;
    private boolean end;
    private final EntryMetadata metadata = new EntryMetadata();
    private boolean nextCallDone = true;
    protected IOException ioException;
    protected BadBioEntryException bbeException;

    @Override
    public Iterator<BEDEntry> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this.end) {
            return false;
        }
        String line = null;
        try {
            while ((line = this.reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (line.startsWith("track ") || line.startsWith("browser ")) {
                    int posTab = line.indexOf(32);
                    if (posTab == -1) continue;
                    String mdKey = line.substring(0, posTab).trim();
                    String mdValue = line.substring(posTab + 1).trim();
                    this.metadata.add(mdKey, mdValue);
                    continue;
                }
                this.result = new BEDEntry(this.metadata);
                this.result.parse(line.trim());
                this.nextCallDone = false;
                return true;
            }
        }
        catch (IOException e) {
            this.ioException = e;
        }
        catch (BadBioEntryException e) {
            this.bbeException = e;
        }
        this.end = true;
        return false;
    }

    @Override
    public BEDEntry next() {
        if (this.nextCallDone) {
            throw new NoSuchElementException();
        }
        this.nextCallDone = true;
        return this.result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Unsupported operation");
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }

    public void throwException() throws IOException, BadBioEntryException {
        if (this.ioException != null) {
            throw this.ioException;
        }
        if (this.bbeException != null) {
            throw this.bbeException;
        }
    }

    public BEDReader(InputStream is) {
        if (is == null) {
            throw new NullPointerException("InputStream is null");
        }
        this.reader = new BufferedReader(new InputStreamReader(is, BioCharsets.BED_CHARSET));
    }

    public BEDReader(File file) throws FileNotFoundException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.reader = FileUtils.createBufferedReader((File)file, (Charset)BioCharsets.BED_CHARSET);
    }

    public BEDReader(String filename) throws FileNotFoundException {
        this.reader = FileUtils.createBufferedReader((String)filename, (Charset)BioCharsets.BED_CHARSET);
    }
}

