/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.io.MarketMatrixExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;

public class CellRangerExpressionMatrixReader
extends MarketMatrixExpressionMatrixReader {
    static final int DEFAULT_CELL_RANGER_FORMAT = 1;
    static final String MATRIX_FILENAME = "matrix.mtx";
    static final String GENES_FILENAME = "genes.tsv";
    static final String BARCODES_FILENAME = "barcodes.tsv";
    static final String MATRIX_V2_FILENAME = "matrix.mtx.gz";
    static final String GENES_V2_FILENAME = "features.tsv.gz";
    static final String BARCODES_V2_FILENAME = "barcodes.tsv.gz";
    private final List<String> geneNames = new ArrayList<String>();
    private final List<String> barcodesNames = new ArrayList<String>();
    private final Map<String, String> geneAliases = new HashMap<String, String>();

    public Map<String, String> getGeneAliases() {
        return this.geneAliases;
    }

    @Override
    protected String getRowName(int rowNumber) {
        return this.geneNames.get(rowNumber - 1);
    }

    @Override
    protected String getColumnName(int columnNumber) {
        return this.barcodesNames.get(columnNumber - 1);
    }

    private static void loadList(File file, List<String> list, Map<String, String> aliases) throws FileNotFoundException, IOException {
        Splitter splitter = Splitter.on((char)'\t').trimResults();
        try (BufferedReader reader = CellRangerExpressionMatrixReader.createReader(file);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                List fields = GuavaCompatibility.splitToList((Splitter)splitter, (CharSequence)line);
                list.add((String)fields.get(0));
                if (aliases == null || fields.size() <= 1) continue;
                aliases.put((String)fields.get(0), (String)fields.get(1));
            }
        }
    }

    private static BufferedReader createReader(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            return new BufferedReader(new InputStreamReader(new GZIPInputStream(new FileInputStream(file))));
        }
        return new BufferedReader(new FileReader(file));
    }

    static int checkCellRangerFormatVersion(int formatVersion) {
        if (formatVersion < 1 || formatVersion > 2) {
            throw new IllegalArgumentException("Invalid format version: " + formatVersion);
        }
        return formatVersion;
    }

    public CellRangerExpressionMatrixReader(File directory) throws IOException {
        this(directory, 1);
    }

    public CellRangerExpressionMatrixReader(File directory, int formatVersion) throws IOException {
        super(new File(directory, CellRangerExpressionMatrixReader.checkCellRangerFormatVersion(formatVersion) == 2 ? MATRIX_V2_FILENAME : MATRIX_FILENAME));
        CellRangerExpressionMatrixReader.loadList(new File(directory, formatVersion == 2 ? GENES_V2_FILENAME : GENES_FILENAME), this.geneNames, this.geneAliases);
        CellRangerExpressionMatrixReader.loadList(new File(directory, formatVersion == 2 ? BARCODES_V2_FILENAME : BARCODES_FILENAME), this.barcodesNames, null);
    }
}

