/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.GFFEntry;
import fr.ens.biologie.genomique.kenetre.bio.io.BioCharsets;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;

public class GFFWriter
implements Closeable {
    private final Writer writer;
    private boolean gff3Format = true;
    private boolean first = true;

    private void writeMetadata(GFFEntry entry) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (this.gff3Format && !entry.getMetadata().containsKey("gff-version")) {
            sb.append("##gff-version 3\n");
        }
        for (Map.Entry<String, List<String>> e : entry.getMetadata().entries().entrySet()) {
            for (String v : e.getValue()) {
                sb.append("##");
                sb.append(e.getKey());
                sb.append(' ');
                sb.append(v);
                sb.append('\n');
            }
        }
        this.writer.write(sb.toString());
    }

    public void write(GFFEntry entry) throws IOException {
        if (entry == null) {
            return;
        }
        if (this.first) {
            this.writeMetadata(entry);
            this.first = false;
        }
        if (this.gff3Format) {
            this.writer.write(entry.toGFF3() + '\n');
        } else {
            this.writer.write(entry.toGTF() + '\n');
        }
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    protected boolean isGFF3Format() {
        return this.gff3Format;
    }

    protected void setGFF3Format(boolean gffFormat) {
        this.gff3Format = gffFormat;
    }

    public GFFWriter(Writer writer) {
        if (writer == null) {
            throw new NullPointerException("The writer is null.");
        }
        this.writer = writer;
    }

    public GFFWriter(OutputStream os) throws FileNotFoundException {
        this.writer = FileUtils.createFastBufferedWriter((OutputStream)os, (Charset)BioCharsets.GFF_CHARSET);
    }

    public GFFWriter(File outputFile) throws IOException {
        this.writer = FileUtils.createFastBufferedWriter((File)outputFile, (Charset)BioCharsets.GFF_CHARSET);
    }

    public GFFWriter(String outputFilename) throws IOException {
        this.writer = FileUtils.createFastBufferedWriter((String)outputFilename, (Charset)BioCharsets.GFF_CHARSET);
    }
}

