/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.DenseExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.ExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.zip.GZIPInputStream;

public class MarketMatrixExpressionMatrixReader
implements ExpressionMatrixReader {
    static final String MAGIC_KEY = "%%MatrixMarket ";
    private final InputStream is;

    protected String getRowName(int rowNumber) {
        return "row" + rowNumber;
    }

    protected String getColumnName(int columnNumber) {
        return "column" + columnNumber;
    }

    @Override
    public ExpressionMatrix read() throws IOException {
        return this.read(new DenseExpressionMatrix());
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ExpressionMatrix read(ExpressionMatrix matrix) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        first = true;
        rowCount = -1;
        columnCount = -1;
        nonzero = -1;
        lineCount = 0;
        reader = FileUtils.createBufferedReader((InputStream)this.is);
        var9_8 = null;
lbl10:
        // 2 sources

        try {
            while ((line = reader.readLine()) != null) {
                block34: {
                    ++lineCount;
                    if (first) {
                        if (!line.startsWith("%%MatrixMarket ")) {
                            throw new IOException("Invalid Market Matrice header: " + line);
                        }
                        fields = GuavaCompatibility.splitToList((Splitter)Splitter.on((char)' ').trimResults().omitEmptyStrings(), (CharSequence)line);
                        if (fields.size() < 2) {
                            throw new IOException("Invalid Market Matrice header: " + line);
                        }
                        if (!"matrix".equals(fields.get(1))) {
                            throw new IOException("The reader only handle matrix files");
                        }
                        block21: for (String s : fields.subList(2, fields.size() - 1)) {
                            var13_17 = s.toLowerCase();
                            var14_19 = -1;
                            switch (var13_17.hashCode()) {
                                case 198931832: {
                                    if (!var13_17.equals("coordinate")) break;
                                    var14_19 = 0;
                                    break;
                                }
                                case 3496350: {
                                    if (!var13_17.equals("real")) break;
                                    var14_19 = 1;
                                    break;
                                }
                                case 1958052158: {
                                    if (!var13_17.equals("integer")) break;
                                    var14_19 = 2;
                                    break;
                                }
                                case -80148248: {
                                    if (!var13_17.equals("general")) break;
                                    var14_19 = 3;
                                }
                            }
                            switch (var14_19) {
                                case 0: 
                                case 1: 
                                case 2: 
                                case 3: {
                                    continue block21;
                                }
                            }
                            throw new IOException("The reader does not support qualifier: " + s);
                        }
                        first = false;
                        continue;
                    }
                    if (line.startsWith("%")) continue;
                    if (line.length() > 1024) {
                        throw new IOException("Invalide line length (>1024), line#" + lineCount + ": " + line);
                    }
                    if ((line = line.trim()).isEmpty()) continue;
                    fields = GuavaCompatibility.splitToList((Splitter)Splitter.on((char)' '), (CharSequence)line);
                    if (fields.size() != 3) {
                        throw new IOException("3 values are expected line #" + lineCount + ": " + line);
                    }
                    try {
                        i = Integer.parseInt((String)fields.get(0));
                        j = Integer.parseInt((String)fields.get(1));
                        value = Double.parseDouble((String)fields.get(2));
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Invalid number format line #" + lineCount + ": " + line);
                    }
                    if (nonzero != -1) break block34;
                    rowCount = i;
                    columnCount = j;
                    nonzero = (int)value;
                    for (k = 1; k <= rowCount; ++k) {
                        matrix.addRow(this.getRowName(k));
                    }
                    for (k = 1; k <= columnCount; ++k) {
                        matrix.addColumn(this.getColumnName(k));
                    }
                    ** GOTO lbl10
                }
                matrix.setValue(this.getRowName(i), this.getColumnName(j), value);
            }
        }
        catch (Throwable var10_12) {
            var9_8 = var10_12;
            throw var10_12;
        }
        finally {
            if (reader != null) {
                if (var9_8 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable var10_11) {
                        var9_8.addSuppressed(var10_11);
                    }
                } else {
                    reader.close();
                }
            }
        }
        return matrix;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    private static InputStream createInputstream(String filename) throws IOException {
        if (filename.endsWith(".gz")) {
            return new GZIPInputStream(new FileInputStream(filename));
        }
        return new FileInputStream(filename);
    }

    private static InputStream createInputstream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            return new GZIPInputStream(new FileInputStream(file));
        }
        return new FileInputStream(file);
    }

    public MarketMatrixExpressionMatrixReader(InputStream is) {
        Objects.requireNonNull(is, "is argument cannot be null");
        this.is = is;
    }

    public MarketMatrixExpressionMatrixReader(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.is = MarketMatrixExpressionMatrixReader.createInputstream(file);
    }

    public MarketMatrixExpressionMatrixReader(String filename) throws IOException {
        Objects.requireNonNull(filename, "filename argument cannot be null");
        this.is = MarketMatrixExpressionMatrixReader.createInputstream(filename);
    }
}

