/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import com.google.common.math.DoubleMath;
import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.Matrix;
import fr.ens.biologie.genomique.kenetre.bio.io.ExpressionMatrixWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.zip.GZIPOutputStream;

public class MarketMatrixExpressionMatrixWriter
implements ExpressionMatrixWriter {
    private final OutputStream os;

    @Override
    public void write(ExpressionMatrix matrix) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        this.write(matrix, matrix.getRowNames());
    }

    @Override
    public void write(ExpressionMatrix matrix, Collection<String> rowNamesToWrite) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        Objects.requireNonNull(rowNamesToWrite, "rowNamesToWrite argument cannot be null");
        Set<Object> rowNames = rowNamesToWrite instanceof Set ? (Set<Object>)rowNamesToWrite : new HashSet<String>(rowNamesToWrite);
        int entryCount = MarketMatrixExpressionMatrixWriter.entryCount(matrix, (Set<String>)rowNames);
        boolean intMatrix = entryCount < -1;
        entryCount = Math.abs(entryCount);
        try (OutputStreamWriter writer = new OutputStreamWriter(this.os);){
            writer.write("%%MatrixMarket ");
            writer.write("matrix coordinate " + (intMatrix ? "integer" : "real") + " general\n");
            writer.write("" + matrix.getRowCount() + ' ' + matrix.getColumnCount() + ' ' + entryCount + '\n');
            Map<String, Integer> rowPositions = MarketMatrixExpressionMatrixWriter.keyPositions(matrix.getRowNames());
            Map<String, Integer> columnPositions = MarketMatrixExpressionMatrixWriter.keyPositions(matrix.getColumnNames());
            for (Matrix.Entry e : matrix.nonZeroValues()) {
                if (!rowNames.contains(e.getRowName())) continue;
                String value = intMatrix ? "" + ((Double)e.getValue()).intValue() : "" + e.getValue();
                writer.write("" + rowPositions.get(e.getRowName()) + ' ' + columnPositions.get(e.getColumnName()) + ' ' + value + '\n');
            }
        }
    }

    private static Map<String, Integer> keyPositions(List<String> entryNames) {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        int count = 1;
        for (String e : entryNames) {
            result.put(e, count++);
        }
        return result;
    }

    private static int entryCount(ExpressionMatrix matrix, Set<String> rowNames) {
        int entryCount = 0;
        boolean intMatrix = true;
        for (Matrix.Entry e : matrix.nonZeroValues()) {
            if (!rowNames.contains(e.getRowName())) continue;
            if (!intMatrix && DoubleMath.isMathematicalInteger((double)((Double)e.getValue()))) {
                intMatrix = false;
            }
            ++entryCount;
        }
        return entryCount * (intMatrix ? -1 : 1);
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    private static OutputStream createOutputstream(String filename) throws IOException {
        if (filename.endsWith(".gz")) {
            return new GZIPOutputStream(new FileOutputStream(filename));
        }
        return new FileOutputStream(filename);
    }

    private static OutputStream createOutputstream(File file) throws IOException {
        if (file.getName().endsWith(".gz")) {
            return new GZIPOutputStream(new FileOutputStream(file));
        }
        return new FileOutputStream(file);
    }

    public MarketMatrixExpressionMatrixWriter(OutputStream os) {
        Objects.requireNonNull(os, "os argument cannot be null");
        this.os = os;
    }

    public MarketMatrixExpressionMatrixWriter(File file) throws IOException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.os = MarketMatrixExpressionMatrixWriter.createOutputstream(file);
    }

    public MarketMatrixExpressionMatrixWriter(String filename) throws IOException {
        Objects.requireNonNull(filename, "filename argument cannot be null");
        this.os = MarketMatrixExpressionMatrixWriter.createOutputstream(filename);
    }
}

