/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import fr.ens.biologie.genomique.kenetre.bio.AnnotationMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.AnnotationMatrixWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Objects;

public class TSVAnnotationMatrixWriter
implements AnnotationMatrixWriter {
    private final OutputStream os;

    @Override
    public void write(AnnotationMatrix matrix) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        this.write(matrix, matrix.getRowNames());
    }

    @Override
    public void write(AnnotationMatrix matrix, Collection<String> rowNamesToWrite) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        Objects.requireNonNull(rowNamesToWrite, "rowNamesToWrite argument cannot be null");
        try (OutputStreamWriter writer = new OutputStreamWriter(this.os);){
            StringBuilder sb = new StringBuilder();
            sb.append("Id");
            for (String columnName : matrix.getColumnNames()) {
                sb.append('\t');
                sb.append(columnName);
            }
            sb.append('\n');
            writer.write(sb.toString());
            for (String rowName : rowNamesToWrite) {
                sb.setLength(0);
                sb.append(rowName);
                for (String value : matrix.getRowValues(rowName)) {
                    sb.append('\t');
                    sb.append(value);
                }
                sb.append('\n');
                writer.write(sb.toString());
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.os.close();
    }

    public TSVAnnotationMatrixWriter(OutputStream os) throws FileNotFoundException {
        Objects.requireNonNull(os, "the os argument cannot be null");
        this.os = os;
    }

    public TSVAnnotationMatrixWriter(File outputFile) throws IOException {
        Objects.requireNonNull(outputFile, "the outputFile argument cannot be null");
        this.os = new FileOutputStream(outputFile);
    }

    public TSVAnnotationMatrixWriter(String outputFilename) throws IOException {
        Objects.requireNonNull(outputFilename, "the outputFilename argument cannot be null");
        this.os = new FileOutputStream(outputFilename);
    }
}

