/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.io;

import com.google.common.base.Splitter;
import fr.ens.biologie.genomique.kenetre.bio.DenseExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.ExpressionMatrix;
import fr.ens.biologie.genomique.kenetre.bio.io.ExpressionMatrixReader;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.util.GuavaCompatibility;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public class TSVExpressionMatrixReader
implements ExpressionMatrixReader {
    private final InputStream is;

    @Override
    public ExpressionMatrix read() throws IOException {
        return this.read(new DenseExpressionMatrix());
    }

    @Override
    public ExpressionMatrix read(ExpressionMatrix matrix) throws IOException {
        Objects.requireNonNull(matrix, "matrix argument cannot be null");
        boolean first = true;
        Splitter splitter = Splitter.on((char)'\t');
        ArrayList columnNames = null;
        try (BufferedReader reader = FileUtils.createBufferedReader((InputStream)this.is);){
            String line;
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                List fields = GuavaCompatibility.splitToList((Splitter)splitter, (CharSequence)line);
                if (first) {
                    if (fields.size() == 1) continue;
                    columnNames = new ArrayList(fields);
                    columnNames.remove(0);
                    first = false;
                    continue;
                }
                if (fields.size() > columnNames.size() + 1) {
                    throw new IOException("Found a line with invalid number of column: " + line);
                }
                Iterator it = columnNames.iterator();
                String rowName = null;
                for (String s : fields) {
                    if (rowName == null) {
                        rowName = s;
                        continue;
                    }
                    matrix.setValue(rowName, (String)it.next(), Double.parseDouble(s));
                }
            }
        }
        return matrix;
    }

    @Override
    public void close() throws IOException {
        this.is.close();
    }

    public TSVExpressionMatrixReader(InputStream is) {
        Objects.requireNonNull(is, "is argument cannot be null");
        this.is = is;
    }

    public TSVExpressionMatrixReader(File file) throws FileNotFoundException {
        Objects.requireNonNull(file, "file argument cannot be null");
        this.is = new FileInputStream(file);
    }

    public TSVExpressionMatrixReader(String filename) throws FileNotFoundException {
        Objects.requireNonNull(filename, "filename argument cannot be null");
        this.is = new FileInputStream(filename);
    }
}

