/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.IlluminaReadId;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;

public class IlluminaFilterFlagReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "illuminaid";
    private IlluminaReadId irid;

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        try {
            if (this.irid == null) {
                this.irid = new IlluminaReadId(read.getName());
            } else {
                this.irid.parse(read.getName());
            }
            if (!this.irid.isFilteredField()) {
                return true;
            }
            return !this.irid.isFiltered();
        }
        catch (KenetreException e) {
            return true;
        }
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Filter read with illumina id";
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{}";
    }
}

