/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.ReadFilter;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class MultiReadFilter
implements ReadFilter {
    private GenericLogger logger = new DummyLogger();
    private final List<ReadFilter> list = new ArrayList<ReadFilter>();
    private final ReporterIncrementer incrementer;
    private final String counterGroup;

    @Override
    public void setLogger(GenericLogger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }

    @Override
    public GenericLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        for (ReadFilter rf : this.list) {
            if (rf.accept(read)) continue;
            if (this.incrementer != null) {
                this.incrementer.incrCounter(this.counterGroup, "reads rejected by " + rf.getName() + " filter", 1L);
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean accept(ReadSequence read1, ReadSequence read2) {
        for (ReadFilter rf : this.list) {
            if (rf.accept(read1, read2)) continue;
            if (this.incrementer != null) {
                this.incrementer.incrCounter(this.counterGroup, "reads rejected by " + rf.getName() + " filter", 1L);
            }
            return false;
        }
        return true;
    }

    public void addFilter(ReadFilter filter) {
        if (filter != null) {
            this.list.add(filter);
        }
    }

    @Override
    public String getName() {
        return "MultiReadFilter";
    }

    @Override
    public String getDescription() {
        return "Multi read filter";
    }

    @Override
    public void setParameter(String key, String value) {
    }

    @Override
    public void init() {
    }

    public List<String> getFilterNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (ReadFilter f : this.list) {
            result.add(f.getName());
        }
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{incrementer=" + this.incrementer + ",counterGroup=" + this.counterGroup + " , list=" + this.list + "}";
    }

    public MultiReadFilter() {
        this(null, null);
    }

    public MultiReadFilter(ReporterIncrementer incrementer, String counterGroup) {
        this.incrementer = incrementer;
        this.counterGroup = counterGroup;
    }

    public MultiReadFilter(List<ReadFilter> filters) {
        this(null, null, filters);
    }

    public MultiReadFilter(ReporterIncrementer incrementer, String counterGroup, List<ReadFilter> filters) {
        this.incrementer = incrementer;
        this.counterGroup = counterGroup;
        if (filters != null) {
            for (ReadFilter filter : filters) {
                this.addFilter(filter);
            }
        }
    }
}

