/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.MultiReadFilter;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.ReadFilter;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.ReadFilterService;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.util.ReporterIncrementer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MultiReadFilterBuilder {
    private GenericLogger logger = new DummyLogger();
    private final Map<String, ReadFilter> mapFilters = new HashMap<String, ReadFilter>();
    private final List<ReadFilter> listFilter = new ArrayList<ReadFilter>();
    private final Map<String, String> mapParameters = new LinkedHashMap<String, String>();

    private void setLogger(GenericLogger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }

    public GenericLogger getLogger() {
        return this.logger;
    }

    public boolean addParameter(String key, String value) throws KenetreException {
        return this.addParameter(key, value, false);
    }

    public boolean addParameter(String key, String value, boolean noExceptionIfFilterNotExists) throws KenetreException {
        ReadFilter filter;
        String filterKey;
        String filterName;
        if (key == null || value == null) {
            return false;
        }
        String keyTrimmed = key.trim();
        int index = keyTrimmed.indexOf(46);
        if (index == -1) {
            filterName = keyTrimmed;
            filterKey = null;
        } else {
            filterName = keyTrimmed.substring(0, index);
            filterKey = keyTrimmed.substring(index + 1);
        }
        if (this.mapFilters.containsKey(filterName)) {
            filter = this.mapFilters.get(filterName);
        } else {
            filter = (ReadFilter)ReadFilterService.getInstance().newService(filterName);
            if (filter == null) {
                if (noExceptionIfFilterNotExists) {
                    return false;
                }
                throw new KenetreException("Unable to find " + filterName + " read filter.");
            }
            filter.setLogger(this.logger);
            this.mapFilters.put(filterName, filter);
            this.listFilter.add(filter);
        }
        if (filterKey != null) {
            String valueTrimmed = value.trim();
            filter.setParameter(filterKey, valueTrimmed);
            this.mapParameters.put(keyTrimmed, valueTrimmed);
            this.getLogger().info("Set read filter \"" + filterName + "\" with parameter: " + filterKey + "=" + valueTrimmed);
        } else {
            this.mapParameters.put(filterName, "");
            this.getLogger().info("Set read filter \"" + filterName + "\" with no parameter");
        }
        return true;
    }

    public void addParameters(Map<String, String> parameters) throws KenetreException {
        if (parameters == null) {
            return;
        }
        for (Map.Entry<String, String> e : parameters.entrySet()) {
            this.addParameter(e.getKey(), e.getValue());
        }
    }

    public MultiReadFilter getReadFilter() throws KenetreException {
        for (ReadFilter f : this.listFilter) {
            f.init();
        }
        return new MultiReadFilter(this.listFilter);
    }

    public MultiReadFilter getReadFilter(ReporterIncrementer incrementer, String counterGroup) throws KenetreException {
        for (ReadFilter f : this.listFilter) {
            f.init();
        }
        return new MultiReadFilter(incrementer, counterGroup, this.listFilter);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.mapParameters);
    }

    public MultiReadFilterBuilder() {
    }

    public MultiReadFilterBuilder(GenericLogger logger) {
        this.setLogger(logger);
    }

    public MultiReadFilterBuilder(Map<String, String> parameters) throws KenetreException {
        this.addParameters(parameters);
    }

    public MultiReadFilterBuilder(GenericLogger logger, Map<String, String> parameters) throws KenetreException {
        this.setLogger(logger);
        this.addParameters(parameters);
    }
}

