/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.ReadFilter;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import java.util.Objects;

public class PairedEndReadFilter
implements ReadFilter {
    private GenericLogger logger = new DummyLogger();
    private boolean acceptPairedEnd = true;
    private final boolean acceptSingleEnd = true;

    @Override
    public void setLogger(GenericLogger logger) {
        Objects.requireNonNull(logger);
        this.logger = logger;
    }

    @Override
    public GenericLogger getLogger() {
        return this.logger;
    }

    @Override
    public boolean accept(ReadSequence read) {
        return this.acceptSingleEnd;
    }

    @Override
    public boolean accept(ReadSequence read1, ReadSequence read2) {
        if (read1 == null || read2 == null) {
            return false;
        }
        return this.acceptPairedEnd;
    }

    @Override
    public String getName() {
        return "pairedend";
    }

    @Override
    public String getDescription() {
        return "Pair end ReadFilter";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("accept.paired.end".equals(key.trim())) {
            this.acceptPairedEnd = Boolean.parseBoolean(value.trim());
        } else if ("accept.single.end".equals(key.trim())) {
            this.acceptPairedEnd = Boolean.parseBoolean(value.trim());
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
    }

    @Override
    public void init() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{acceptSingleEnd=" + this.acceptSingleEnd + ", acceptPairedEnd=" + this.acceptPairedEnd + "}";
    }
}

