/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import java.util.Objects;

public class PolyATailReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "polyatail";
    private double maximalErrorRate = 0.1;
    private int minimalLength = 10;
    private int minStatLength = 5;

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "PolyA identifier";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        switch (key) {
            case "maximal.error.rate": {
                try {
                    this.maximalErrorRate = Double.parseDouble(value);
                    if (this.maximalErrorRate < 0.0 || this.maximalErrorRate > 1.0) {
                        throw new KenetreException(this.getName() + "." + key + " argument must be greater than 0 and lower than 1");
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    throw new KenetreException("Invalid value for " + this.getName() + "." + key + ": " + value);
                }
            }
            case "minimal.length": {
                try {
                    this.minimalLength = Integer.parseInt(value);
                    if (this.minimalLength < 0) {
                        throw new KenetreException("value for " + this.getName() + "." + key + "cannot be lower than zero: " + value);
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    throw new KenetreException("Invalid value for " + this.getName() + "." + key + ": " + value);
                }
            }
            case "minimal.length.for.error.rate.computation": {
                try {
                    this.minStatLength = Integer.parseInt(value);
                    if (this.minStatLength < 0) {
                        throw new KenetreException("value for " + this.getName() + "." + key + "cannot be lower than zero: " + value);
                    }
                    break;
                }
                catch (NumberFormatException e) {
                    throw new KenetreException("Invalid value for " + this.getName() + "." + key + ": " + value);
                }
            }
            default: {
                throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
            }
        }
    }

    @Override
    public boolean accept(ReadSequence read) {
        int max;
        String sequence = read.getSequence();
        int polyAlength = PolyATailReadFilter.polyATailLength(sequence, this.minStatLength, this.maximalErrorRate);
        int polyTlength = PolyATailReadFilter.polyTTailLength(sequence, this.minStatLength, this.maximalErrorRate);
        TailType tailType = polyAlength < this.minimalLength && polyTlength < this.minimalLength ? TailType.INVALID : (polyAlength >= this.minimalLength && polyTlength >= this.minimalLength ? (polyAlength == polyTlength ? TailType.AMBIGUOUS : (polyAlength == (max = Math.max(polyAlength, polyTlength)) ? TailType.POLYA : TailType.POLYT)) : (polyAlength >= this.minimalLength ? TailType.POLYA : TailType.POLYT));
        read.setName(read.getName() + " tail_type=" + (Object)((Object)tailType));
        return true;
    }

    static int polyTTailLength(String sequence, int minLen, double maximalErrorRate) {
        Objects.requireNonNull(sequence);
        if (minLen < 0) {
            throw new IllegalArgumentException("minLen argument cannot be lower than 0");
        }
        if (maximalErrorRate < 0.0 || maximalErrorRate > 1.0) {
            throw new IllegalArgumentException("maximalErrorRate argument must be greater than 0 and lower than 1");
        }
        int len = sequence.length();
        float threshold = 1.0f - (float)maximalErrorRate;
        int countA = 0;
        int lastA = 0;
        for (int pos = 0; pos < len && (pos < minLen || (float)countA / (float)pos > threshold); ++pos) {
            if (sequence.charAt(pos) != 'T') continue;
            ++countA;
            lastA = pos + 1;
        }
        return lastA;
    }

    static int polyATailLength(String sequence, int minLen, double threshold) {
        Objects.requireNonNull(sequence);
        if (minLen < 0) {
            throw new IllegalArgumentException("minLen argument cannot be lower than 0");
        }
        if (threshold < 0.0 || threshold > 1.0) {
            throw new IllegalArgumentException("threshold argument must be greater than 0 and lower than 1");
        }
        int len = sequence.length();
        float thresholdFloat = 1.0f - (float)threshold;
        int countA = 0;
        int pos = len - 1;
        int lastA = 0;
        for (int count = 0; pos >= 0 && (count < minLen || (float)countA / (float)count > thresholdFloat); --pos, ++count) {
            if (sequence.charAt(pos) != 'A') continue;
            ++countA;
            lastA = len - pos;
        }
        return lastA;
    }

    static enum TailType {
        POLYA("polyA"),
        POLYT("polyT"),
        AMBIGUOUS("ambiguous"),
        INVALID("invalid");

        private String name;

        public static TailType parse(String s) {
            if (s == null) {
                return null;
            }
            for (TailType t : TailType.values()) {
                if (!t.name.equalsIgnoreCase(s.trim())) continue;
                return t;
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        private TailType(String name) {
            this.name = name;
        }
    }
}

