/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import fr.ens.biologie.genomique.kenetre.util.StatUtils;

public class QualityReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "quality";
    private double qualityThreshold = -1.0;

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        return StatUtils.mean((int[])read.qualityScores()) > this.qualityThreshold;
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Quality threshold ReadFilter";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("threshold".equals(key.trim())) {
            try {
                this.qualityThreshold = Double.parseDouble(value.trim());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (this.qualityThreshold < 0.0) {
                throw new KenetreException("Invalid qualityThreshold: " + this.qualityThreshold);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
    }

    @Override
    public void init() {
        if (this.qualityThreshold < 0.0) {
            throw new IllegalArgumentException("Quality threshold is not set for " + this.getName() + " read filter.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{qualityThreshold=" + this.qualityThreshold + "}";
    }
}

