/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ReadNameRegexReadFilter
extends AbstractReadFilter {
    private Pattern allowedPattern;
    private Pattern forbiddenPattern;

    @Override
    public String getName() {
        return "readnameregex";
    }

    @Override
    public String getDescription() {
        return "Filter reads names with regex";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("forbidden.regex".equals(key.trim())) {
            try {
                this.forbiddenPattern = Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                throw new KenetreException("Invalid forbidden regex expression in " + this.getName() + " read filter: " + value);
            }
        } else if ("allowed.regex".equals(key.trim())) {
            try {
                this.allowedPattern = Pattern.compile(value);
            }
            catch (PatternSyntaxException e) {
                throw new KenetreException("Invalid forbidden regex expression in " + this.getName() + " read filter: " + value);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
    }

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        String name = read.getName();
        if (name == null) {
            return false;
        }
        if (this.allowedPattern != null && !this.allowedPattern.matcher(name).find()) {
            return false;
        }
        return this.forbiddenPattern == null || !this.forbiddenPattern.matcher(name).find();
    }
}

