/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import java.util.HashSet;
import java.util.Set;

public class ReadNameStartsWithReadFilter
extends AbstractReadFilter {
    private Set<String> forbiddenPrefixes;
    private Set<String> allowedPrefixes;

    @Override
    public String getName() {
        return "readnamestartwith";
    }

    @Override
    public String getDescription() {
        return "Filter reads names that starts with some prefixes";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("forbidden.prefixes".equals(key.trim())) {
            String[] prefixes;
            if (this.forbiddenPrefixes == null) {
                this.forbiddenPrefixes = new HashSet<String>();
            }
            if ((prefixes = value.split(",")) != null) {
                for (String s : prefixes) {
                    this.forbiddenPrefixes.add(s.trim());
                }
            }
        } else if ("allowed.prefixes".equals(key.trim())) {
            String[] prefixes;
            if (this.allowedPrefixes == null) {
                this.allowedPrefixes = new HashSet<String>();
            }
            if ((prefixes = value.split(",")) != null) {
                for (String s : prefixes) {
                    this.allowedPrefixes.add(s.trim());
                }
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
    }

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        String name = read.getName();
        if (name == null) {
            return false;
        }
        if (this.forbiddenPrefixes != null) {
            for (String prefix : this.forbiddenPrefixes) {
                if (!name.startsWith(prefix)) continue;
                return false;
            }
        }
        if (this.allowedPrefixes != null) {
            for (String prefix : this.allowedPrefixes) {
                if (!name.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

