/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;

public class RequireGGGHeadReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "requireggghead";
    private static final int ADDITIONAL_BASE_COUNT = 3;
    private boolean mismatch = true;

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "additional GGG identifier";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        switch (key) {
            case "allow.mismatch": {
                this.mismatch = Boolean.parseBoolean(value);
                break;
            }
            default: {
                throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
            }
        }
    }

    @Override
    public boolean accept(ReadSequence read) {
        String sequence = read.getSequence();
        int length = read.length();
        if (length < 3) {
            return false;
        }
        String start = sequence.substring(0, Math.min(3, length));
        return RequireGGGHeadReadFilter.count(start, 'G') >= (this.mismatch ? 2 : 3);
    }

    private static int count(String s, char c) {
        int result = 0;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != c) continue;
            ++result;
        }
        return result;
    }
}

