/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.bio.readfilter;

import fr.ens.biologie.genomique.kenetre.KenetreException;
import fr.ens.biologie.genomique.kenetre.bio.ReadSequence;
import fr.ens.biologie.genomique.kenetre.bio.readfilter.AbstractReadFilter;
import java.util.regex.Pattern;

public class TrimReadFilter
extends AbstractReadFilter {
    public static final String FILTER_NAME = "trim";
    private static final Pattern PATTERN = Pattern.compile("NN+$");
    private int lengthThreshold;

    public static void trim(ReadSequence read) {
        if (read == null || read.getSequence() == null || read.getQuality() == null || read.getSequence().length() != read.getQuality().length() || read.getSequence().length() == 0) {
            return;
        }
        String[] splitResult = PATTERN.split(read.getSequence());
        if (splitResult == null || splitResult.length == 0) {
            read.setSequence("");
            read.setQuality("");
            return;
        }
        ReadSequence tmp = read.subSequence(0, splitResult[0].length());
        read.setSequence(tmp.getSequence());
        read.setQuality(tmp.getQuality());
    }

    @Override
    public boolean accept(ReadSequence read) {
        if (read == null) {
            return false;
        }
        TrimReadFilter.trim(read);
        return read.length() > this.lengthThreshold;
    }

    @Override
    public String getName() {
        return FILTER_NAME;
    }

    @Override
    public String getDescription() {
        return "Trim ReadFilter";
    }

    @Override
    public void setParameter(String key, String value) throws KenetreException {
        if (key == null || value == null) {
            return;
        }
        if ("length.threshold".equals(key.trim())) {
            try {
                this.lengthThreshold = Integer.parseInt(value.trim());
            }
            catch (NumberFormatException e) {
                return;
            }
            if (this.lengthThreshold < 1) {
                throw new KenetreException("Invalid length threshold: " + this.lengthThreshold);
            }
        } else {
            throw new KenetreException("Unknown parameter for " + this.getName() + " read filter: " + key);
        }
    }

    @Override
    public void init() {
        if (this.lengthThreshold < 1) {
            throw new IllegalArgumentException("Length threshold is not set for " + this.getName() + " read filter.");
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{lengthThreshold=" + this.lengthThreshold + "}";
    }
}

