/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.storage;

import fr.ens.biologie.genomique.kenetre.bio.GenomeDescription;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.log.DummyLogger;
import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import fr.ens.biologie.genomique.kenetre.storage.GenomeDescStorage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

public abstract class AbstractFileGenomeDescStorage
implements GenomeDescStorage {
    private static final String INDEX_FILENAME = "genomes_desc_storage.txt";
    private final DataPath dir;
    protected final Map<String, IndexEntry> entries = new LinkedHashMap<String, IndexEntry>();
    protected String lastMD5Computed;
    protected DataPath lastGenomeFile;
    protected long lastGenomeFileModified;
    private final GenericLogger logger;

    protected abstract DataPath newDataPath(String var1);

    protected abstract DataPath newDataPath(DataPath var1, String var2);

    private void load() throws IOException {
        if (!this.dir.exists()) {
            throw new IOException("Genome description storage directory not found: " + this.dir.getSource());
        }
        DataPath indexFile = this.newDataPath(this.dir, INDEX_FILENAME);
        if (!indexFile.exists()) {
            this.save();
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(indexFile.open(), Charset.defaultCharset()));
        Pattern pattern = Pattern.compile("\t");
        String line = null;
        while ((line = br.readLine()) != null) {
            List<String> fields;
            String trimmedLine = line.trim();
            if ("".equals(trimmedLine) || trimmedLine.startsWith("#") || (fields = Arrays.asList(pattern.split(trimmedLine))).size() != 4) continue;
            IndexEntry e = new IndexEntry();
            e.genomeName = fields.get(0);
            e.genomeFileMD5Sum = fields.get(1);
            e.genomeFileLength = Long.parseLong(fields.get(2));
            e.file = this.newDataPath(this.dir, fields.get(3));
            if (!e.file.exists()) continue;
            this.entries.put(e.getKey(), e);
        }
        br.close();
    }

    private void save() throws IOException {
        if (!this.dir.exists()) {
            throw new IOException("Genome description storage directory not found: " + this.dir.getSource());
        }
        DataPath indexFile = this.newDataPath(this.dir, INDEX_FILENAME);
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(indexFile.create(), Charset.defaultCharset()));
        writer.write("#Genome\tGenomeFileMD5\tGenomeFileLength\n");
        for (Map.Entry<String, IndexEntry> e : this.entries.entrySet()) {
            IndexEntry ie = e.getValue();
            writer.append(ie.genomeName);
            writer.append("\t");
            writer.append(ie.genomeFileMD5Sum);
            writer.append("\t");
            writer.append(Long.toString(ie.genomeFileLength));
            writer.append("\t");
            writer.append(ie.file.getName());
            writer.append("\n");
        }
        writer.close();
    }

    private String createKey(DataPath genomeFile) {
        try {
            String md5Sum = this.computeMD5Sum(genomeFile);
            return AbstractFileGenomeDescStorage.createKey(genomeFile.getContentLength(), md5Sum);
        }
        catch (IOException e) {
            return null;
        }
    }

    private static String createKey(long genomeFileLength, String genomeFileMD5Sum) {
        return genomeFileMD5Sum + '\t' + genomeFileLength;
    }

    protected String computeMD5Sum(DataPath genomeFile) throws IOException {
        if (genomeFile.equals(this.lastGenomeFile) && this.lastGenomeFileModified == genomeFile.getLastModified() && this.lastMD5Computed != null) {
            return this.lastMD5Computed;
        }
        String md5Sum = FileUtils.computeMD5Sum((InputStream)genomeFile.rawOpen());
        if (md5Sum != null) {
            this.lastGenomeFile = genomeFile;
            this.lastGenomeFileModified = genomeFile.getLastModified();
            this.lastMD5Computed = md5Sum;
        }
        return md5Sum;
    }

    @Override
    public GenomeDescription get(String genomePath) {
        Objects.requireNonNull(genomePath, "Genome file is null");
        DataPath genomeFile = this.newDataPath(genomePath);
        IndexEntry entry = this.entries.get(this.createKey(genomeFile));
        if (entry == null || entry.file == null) {
            return null;
        }
        try {
            return GenomeDescription.load((InputStream)entry.file.open());
        }
        catch (IOException e) {
            this.logger.warn("Cannot read genome description file: " + e.getMessage());
            return null;
        }
    }

    @Override
    public void put(String genomePath, GenomeDescription genomeDesc) {
        Objects.requireNonNull(genomePath, "GenomeFile is null");
        Objects.requireNonNull(genomeDesc, "Genome description is null");
        DataPath genomeFile = this.newDataPath(genomePath);
        String key = this.createKey(genomeFile);
        if (this.entries.containsKey(key)) {
            return;
        }
        try {
            IndexEntry entry = new IndexEntry();
            entry.genomeName = genomeFile.getName();
            entry.genomeFileLength = genomeFile.getContentLength();
            entry.genomeFileMD5Sum = this.computeMD5Sum(genomeFile);
            entry.file = this.newDataPath(this.dir, entry.genomeFileMD5Sum + "_" + entry.genomeFileLength + ".gdesc");
            genomeDesc.save(entry.file.create());
            this.entries.put(entry.getKey(), entry);
            this.save();
            this.logger.info("Successfully added " + entry.genomeName + " genome description to genome description storage.");
        }
        catch (IOException e) {
            this.logger.warn("Cannot add genome description file to genome description storage: " + e.getMessage());
        }
    }

    protected AbstractFileGenomeDescStorage(DataPath dir, GenericLogger logger) throws IOException {
        Objects.requireNonNull(dir, "Index directory is null");
        this.dir = dir;
        this.logger = logger != null ? logger : new DummyLogger();
        this.load();
        this.logger.info("Genome description storage found. " + this.entries.size() + " entries in : " + dir.getSource());
    }

    private static final class IndexEntry {
        String genomeName;
        long genomeFileLength;
        String genomeFileMD5Sum;
        DataPath file;

        private IndexEntry() {
        }

        private String getKey() {
            return AbstractFileGenomeDescStorage.createKey(this.genomeFileLength, this.genomeFileMD5Sum);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "{genomeName=" + this.genomeName + ", genomeFileLength=" + this.genomeFileLength + ", genomeFileMD5Sum=" + this.genomeFileMD5Sum + ", file=" + this.file + "}";
        }
    }
}

