/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.storage;

import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public abstract class AbstractFileStorage {
    private final DataPath rootPath;
    private final List<String> extensions;

    protected List<String> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    protected abstract DataPath newDataPath(String var1);

    protected abstract DataPath newDataPath(DataPath var1, String var2);

    public File getFile(String shortName) throws IOException {
        DataPath result = this.getDataPath(shortName);
        return result != null ? result.toFile() : null;
    }

    protected DataPath getDataPath(String shortName) throws IOException {
        Objects.requireNonNull(shortName);
        if (!this.rootPath.exists()) {
            throw new IOException("Storage base path does not exists: " + this.rootPath.getSource());
        }
        List<DataPath> dirList = this.rootPath.list();
        ArrayList<String> extensions = new ArrayList<String>(this.getExtensions());
        extensions.add("");
        for (String extension : extensions) {
            if (extension == null) {
                throw new NullPointerException("One of the extensions of the storage protocol is null");
            }
            String filename = shortName.trim() + extension;
            for (CompressionType c : CompressionType.values()) {
                DataPath file = this.newDataPath(this.rootPath, filename + c.getExtension());
                if (file.exists()) {
                    return file.canonicalize();
                }
                if (!dirList.isEmpty()) {
                    String filenameLower = file.getName().toLowerCase();
                    for (DataPath f : dirList) {
                        if (!f.getName().toLowerCase().equals(filenameLower) || !f.exists()) continue;
                        return f.canonicalize();
                    }
                    continue;
                }
                DataPath fileLower = this.newDataPath(this.rootPath, file.getName().toLowerCase());
                if (fileLower.exists()) {
                    return fileLower.canonicalize();
                }
                DataPath fileUpper = this.newDataPath(this.rootPath, file.getName().toUpperCase());
                if (!fileUpper.exists()) continue;
                return fileUpper.canonicalize();
            }
        }
        return null;
    }

    protected AbstractFileStorage(String rootPath, List<String> extensions) {
        Objects.requireNonNull(rootPath);
        Objects.requireNonNull(extensions);
        if (extensions.isEmpty()) {
            throw new IllegalArgumentException("extension list cannot be empty");
        }
        this.rootPath = this.newDataPath(rootPath);
        this.extensions = extensions;
    }
}

