/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.storage;

import fr.ens.biologie.genomique.kenetre.io.CompressionType;
import fr.ens.biologie.genomique.kenetre.io.FileUtils;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class FileDataPath
implements DataPath,
Comparable<FileDataPath> {
    private final File file;

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getSource() {
        return this.file.getPath();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public InputStream open() throws IOException {
        CompressionType ct = CompressionType.getCompressionTypeByFilename((String)this.file.getName());
        return ct.createInputStream(this.rawOpen());
    }

    @Override
    public InputStream rawOpen() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public OutputStream create() throws IOException {
        CompressionType ct = CompressionType.getCompressionTypeByFilename((String)this.file.getName());
        return ct.createOutputStream(this.rawCreate());
    }

    @Override
    public OutputStream rawCreate() throws IOException {
        return new FileOutputStream(this.file);
    }

    @Override
    public long getContentLength() {
        return this.file.length();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public DataPath canonicalize() throws IOException {
        return new FileDataPath(this.file.getCanonicalPath());
    }

    @Override
    public List<DataPath> list() throws IOException {
        if (!this.file.exists()) {
            throw new FileNotFoundException("File not found: " + this.file);
        }
        if (!this.file.isDirectory()) {
            throw new IOException("The file is not a directory: " + this.file);
        }
        File[] files = this.file.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        ArrayList<FileDataPath> result = new ArrayList<FileDataPath>(files.length);
        for (File f : files) {
            result.add(new FileDataPath(f));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public File toFile() {
        return this.file;
    }

    @Override
    public void copy(DataPath output) throws IOException {
        Objects.requireNonNull(output);
        FileUtils.copy((InputStream)this.open(), (OutputStream)output.create());
    }

    @Override
    public void symlinkOrCopy(DataPath link) throws IOException {
        Objects.requireNonNull(link);
        if (link.exists()) {
            throw new IOException("the symlink already exists");
        }
        Path targetPath = this.file.toPath();
        Path linkPath = link.toFile().toPath();
        Files.createSymbolicLink(linkPath, targetPath, new FileAttribute[0]);
    }

    @Override
    public int compareTo(FileDataPath o) {
        if (o == null) {
            return -1;
        }
        return this.file.compareTo(o.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public boolean equals(Object obj) {
        return this.file.equals(obj);
    }

    public String toString() {
        return this.file.toString();
    }

    public FileDataPath(String source) {
        Objects.requireNonNull(source);
        this.file = new File(source);
    }

    public FileDataPath(File file) {
        Objects.requireNonNull(file);
        this.file = file;
    }

    public FileDataPath(DataPath parent, String filename) {
        Objects.requireNonNull(parent);
        Objects.requireNonNull(filename);
        if (!(parent instanceof FileDataPath)) {
            throw new IllegalArgumentException("parent is not a PathDataPath object");
        }
        FileDataPath p = (FileDataPath)parent;
        this.file = new File(p.file, filename);
    }
}

