/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.biologie.genomique.kenetre.storage;

import fr.ens.biologie.genomique.kenetre.log.GenericLogger;
import fr.ens.biologie.genomique.kenetre.storage.AbstractFileGenomeDescStorage;
import fr.ens.biologie.genomique.kenetre.storage.DataPath;
import fr.ens.biologie.genomique.kenetre.storage.FileDataPath;
import fr.ens.biologie.genomique.kenetre.storage.GenomeDescStorage;
import java.io.IOException;
import java.util.Objects;

public class FileGenomeDescStorage
extends AbstractFileGenomeDescStorage {
    @Override
    protected DataPath newDataPath(String source) {
        return new FileDataPath(source);
    }

    @Override
    protected DataPath newDataPath(DataPath parent, String filename) {
        return new FileDataPath(parent, filename);
    }

    public static GenomeDescStorage getInstance(String dir, GenericLogger logger) {
        Objects.requireNonNull(dir);
        try {
            return new FileGenomeDescStorage(new FileDataPath(dir), logger);
        }
        catch (IOException | NullPointerException e) {
            return null;
        }
    }

    private FileGenomeDescStorage(DataPath dir, GenericLogger logger) throws IOException {
        super(dir, logger);
    }
}

