/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn;

import fr.ens.transcriptome.teolenn.WeightsSetter;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilter;
import fr.ens.transcriptome.teolenn.output.Output;
import fr.ens.transcriptome.teolenn.selector.SequenceSelector;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceFilter;
import java.io.File;
import java.security.InvalidParameterException;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Design {
    private int oligoLength = 60;
    private int oligoIntervalLength = 0;
    private File genomeFile;
    private File genomeMaskedFile;
    private File outputDir = new File("").getAbsoluteFile();
    private File oligosDir;
    private File tempDir;
    private boolean start1 = false;
    private boolean skipSequenceCreation;
    private boolean skipSequenceFilters;
    private boolean skipMeasurementsComputation;
    private boolean skipMeasurementsFilters;
    private boolean skipSelector;
    private List<SequenceFilter> sequenceFiltersList;
    private List<Measurement> measurementsList;
    private List<MeasurementFilter> measurementFiltersList;
    private SequenceSelector selector;
    private WeightsSetter weightSetters;
    private List<Output> outputsList;

    public int getOligoLength() {
        return this.oligoLength;
    }

    public int getOligoIntervalLength() {
        return this.oligoIntervalLength;
    }

    public File getGenomeFile() {
        return this.genomeFile;
    }

    public File getGenomeMaskedFile() {
        return this.genomeMaskedFile;
    }

    public File getOligosDir() {
        if (this.oligosDir == null) {
            this.oligosDir = new File(this.getOutputDir(), "oligos");
        }
        return this.oligosDir;
    }

    public File getTempDir() {
        if (this.tempDir == null) {
            this.tempDir = new File(this.getOutputDir(), "tmp");
        }
        return this.tempDir;
    }

    public File getOutputDir() {
        return this.outputDir;
    }

    public boolean isSkipSequenceCreation() {
        return this.skipSequenceCreation;
    }

    public boolean isSkipSequenceFilters() {
        return this.skipSequenceFilters;
    }

    public boolean isSkipMeasurementsComputation() {
        return this.skipMeasurementsComputation;
    }

    public boolean isSkipMeasurementsFilters() {
        return this.skipMeasurementsFilters;
    }

    public boolean isSkipSelector() {
        return this.skipSelector;
    }

    public boolean isGenomeMaskedFile() {
        return this.genomeMaskedFile != null;
    }

    public boolean isStart1() {
        return this.start1;
    }

    public List<SequenceFilter> getSequenceFiltersList() {
        return this.sequenceFiltersList;
    }

    public List<Measurement> getMeasurementsList() {
        return this.measurementsList;
    }

    public List<MeasurementFilter> getMeasurementFiltersList() {
        return this.measurementFiltersList;
    }

    public SequenceSelector getSelector() {
        return this.selector;
    }

    public WeightsSetter getWeightSetters() {
        return this.weightSetters;
    }

    public List<Output> getOutputList() {
        return this.outputsList;
    }

    public void setOligoLength(int oligoLength) {
        if (oligoLength <= 0) {
            throw new IllegalArgumentException("Invalid oligo length value: " + oligoLength);
        }
        this.oligoLength = oligoLength;
    }

    public void setOligoIntervalLength(int oligoIntervalLength) {
        if (oligoIntervalLength < 0) {
            throw new IllegalArgumentException("Invalid oligo interval length value: " + oligoIntervalLength);
        }
        if (this.getOligoLength() - oligoIntervalLength < 1) {
            throw new IllegalArgumentException("Oligo interval can't be greater or equals to oligo length: " + oligoIntervalLength);
        }
        this.oligoIntervalLength = oligoIntervalLength;
    }

    public void setGenomeFile(File genomeFile) {
        this.genomeFile = genomeFile;
    }

    public void setGenomeMaskedFile(File genomeMaskedFile) {
        this.genomeMaskedFile = genomeMaskedFile;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public void setSkipSequenceCreation(boolean skipSequenceCreation) {
        this.skipSequenceCreation = skipSequenceCreation;
    }

    public void setSkipSequenceFilters(boolean skipSequenceFilters) {
        this.skipSequenceFilters = skipSequenceFilters;
    }

    public void setSkipMeasurementsComputation(boolean skipMeasurementsComputation) {
        this.skipMeasurementsComputation = skipMeasurementsComputation;
    }

    public void setSkipMeasurementsFilters(boolean skipMeasurementsFilters) {
        this.skipMeasurementsFilters = skipMeasurementsFilters;
    }

    public void setSkipSelector(boolean skipSelector) {
        this.skipSelector = skipSelector;
    }

    public void setStart1(boolean start1) {
        this.start1 = start1;
    }

    public void setOligosDir(File oligosDir) {
        this.oligosDir = oligosDir;
    }

    public void setTempDir(File tempDir) {
        this.tempDir = tempDir;
    }

    public void setSequenceFiltersList(List<SequenceFilter> sequenceFiltersList) {
        if (sequenceFiltersList == null) {
            throw new InvalidParameterException("The list of sequence filter can't be null.");
        }
        this.sequenceFiltersList = sequenceFiltersList;
    }

    public void setMeasurementsList(List<Measurement> measurementsList) {
        if (measurementsList == null) {
            throw new InvalidParameterException("The list of measurements can't be null.");
        }
        this.measurementsList = measurementsList;
    }

    public void setMeasurementFiltersList(List<MeasurementFilter> measurementFilterList) {
        if (measurementFilterList == null) {
            throw new InvalidParameterException("The list of measurement filters can't be null.");
        }
        this.measurementFiltersList = measurementFilterList;
    }

    public void setSelector(SequenceSelector selector) {
        if (selector == null) {
            throw new InvalidParameterException("The selector can't be null.");
        }
        this.selector = selector;
    }

    public void setWeightSetters(WeightsSetter weightSetters) {
        if (weightSetters == null) {
            throw new InvalidParameterException("The weightsetter can't be null.");
        }
        this.weightSetters = weightSetters;
    }

    public void setOutputsList(List<Output> outputsList) {
        if (outputsList == null) {
            throw new InvalidParameterException("The list of outputs can't be null.");
        }
        this.outputsList = outputsList;
    }
}

