/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn;

import fr.ens.transcriptome.teolenn.Design;
import fr.ens.transcriptome.teolenn.Module;
import fr.ens.transcriptome.teolenn.Settings;
import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.WeightsSetter;
import fr.ens.transcriptome.teolenn.core.MeasurementCore;
import fr.ens.transcriptome.teolenn.core.SequenceCore;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilter;
import fr.ens.transcriptome.teolenn.measurement.io.MultiSequenceMeasurementWriter;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsIOFactory;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.output.Output;
import fr.ens.transcriptome.teolenn.resource.ChromosomeNameResource;
import fr.ens.transcriptome.teolenn.resource.OligoSequenceResource;
import fr.ens.transcriptome.teolenn.selector.SequenceSelector;
import fr.ens.transcriptome.teolenn.sequence.SequenceIterator;
import fr.ens.transcriptome.teolenn.sequence.SequenceWriter;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceFilter;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import fr.ens.transcriptome.teolenn.util.StringUtils;
import fr.ens.transcriptome.teolenn.util.SystemUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignCommand
extends Design {
    private static final Logger logger = Logger.getLogger("Teolenn");
    private long startTimeCurrentPhase;
    private long startTimeDesign;

    public void execute() throws TeolennException {
        this.phase0();
        if (!this.isSkipPhase1()) {
            this.phase1CreateAllOligos();
        } else {
            ChromosomeNameResource.getRessource(this.getOligosDir()).load();
        }
        if (!this.isSkipPhase2()) {
            this.phase2FilterAllOligos(this.getSequenceFiltersList());
        }
        this.phase3CalcMeasurements(this.getMeasurementsList());
        if (!this.isSkipPhase4()) {
            this.phase4FilterMeasurements(this.getMeasurementFiltersList(), true);
        }
        if (!this.isSkipPhase5()) {
            this.phase5Select(this.getSelector(), this.getWeightSetters());
        }
    }

    public void setDefaultModuleInitParameters(Module module) {
        if (module == null) {
            return;
        }
        module.setInitParameter("_genomefile", this.getGenomeFile().getAbsolutePath());
        module.setInitParameter("_genomemaskedfile", this.getGenomeMaskedFile().getAbsolutePath());
        module.setInitParameter("_outputdir", this.getOutputDir().getAbsolutePath());
        module.setInitParameter("_oligolength", Integer.toString(this.getOligoLength()));
        module.setInitParameter("_oligointervallength", Integer.toString(this.getOligoIntervalLength()));
        module.setInitParameter("_extensionfilter", ".oligo");
        module.setInitParameter("_oligodir", this.getOligosDir().getAbsolutePath());
        module.setInitParameter("_tempdir", this.getTempDir().getAbsolutePath());
        module.setInitParameter("_start1", Boolean.toString(this.isStart1()));
    }

    private boolean isSkipPhase1() {
        return this.isSkipSequenceCreation() || this.isSkipMeasurementsComputation();
    }

    private boolean isSkipPhase2() {
        return this.isSkipMeasurementsComputation() || this.isSkipSequenceFilters();
    }

    private boolean isSkipPhase3() {
        return this.isSkipMeasurementsComputation();
    }

    private boolean isSkipPhase4() {
        return this.isSkipMeasurementsFilters();
    }

    public boolean isSkipPhase5() {
        return this.isSkipSelector();
    }

    private static final void filterSequencesFiles(List<File> oligoFiles, List<SequenceFilter> sequenceFilters, boolean maskedFiles) throws IOException {
        int count = 0;
        for (File oligoFile : oligoFiles) {
            String basename = StringUtils.basename(oligoFile.getAbsolutePath());
            SequenceIterator si1 = new SequenceIterator(oligoFile);
            SequenceIterator si2 = maskedFiles ? new SequenceIterator(new File(basename + ".masked")) : null;
            SequenceWriter sw1 = new SequenceWriter(new File(basename + ".oligo.filtered"));
            SequenceWriter sw2 = maskedFiles ? new SequenceWriter(new File(basename + ".masked.filtered")) : null;
            SequenceFilter[] filters = sequenceFilters.toArray(new SequenceFilter[0]);
            while (si1.hasNext()) {
                si1.next();
                if (maskedFiles) {
                    si2.next();
                }
                boolean result = true;
                for (int j = 0; j < filters.length; ++j) {
                    if (filters[j].accept(si1)) continue;
                    result = false;
                    break;
                }
                if (!result) continue;
                sw1.write(si1);
                if (maskedFiles) {
                    sw2.write(si2);
                }
                ++count;
            }
            sw1.close();
            if (!maskedFiles) continue;
            sw2.close();
        }
        logger.info("" + count + " oligonucleotides after filtering");
    }

    private int countOligosCreated(Map<String, Integer> chrOligo) {
        if (chrOligo == null) {
            return 0;
        }
        int count = 0;
        for (Map.Entry<String, Integer> e : chrOligo.entrySet()) {
            count += e.getValue().intValue();
        }
        return count;
    }

    private void verifyChromosomeLengths(Map<String, Integer> chrOligo, Map<String, Integer> chrMasked) throws TeolennException {
        if (chrOligo == null) {
            throw new TeolennException("chrOligo is null");
        }
        if (chrMasked == null) {
            throw new TeolennException("chrOligo is null");
        }
        if (chrOligo.size() != chrMasked.size()) {
            throw new TeolennException("The number of chromosomes in sequences masked and non masked are not the same.");
        }
        for (Map.Entry<String, Integer> e : chrOligo.entrySet()) {
            String key = e.getKey();
            if (!chrMasked.containsKey(key)) {
                throw new TeolennException("Unknown masked chromosome: " + key);
            }
            if (chrMasked.get(key).intValue() == e.getValue().intValue()) continue;
            throw new TeolennException("The length of the " + key + " chromosome is not the same in masked sequence masked and non masked : " + e.getValue() + " bp / " + chrMasked.get(key) + " bp (masked)");
        }
    }

    public void phase0() throws TeolennException {
        logger.info("Date: " + new Date(System.currentTimeMillis()));
        logger.info("Host: " + SystemUtils.getHostName());
        logger.info("Operating system name: " + System.getProperty("os.name"));
        logger.info("Operating system arch: " + System.getProperty("os.arch"));
        logger.info("Operating system version: " + System.getProperty("os.version"));
        logger.info("Java version: " + System.getProperty("java.version"));
        logger.info("Log level: " + logger.getLevel());
        logger.info("Max threads: " + Settings.getMaxThreads());
        logger.info("Start position: " + (this.isStart1() ? "1" : "0"));
        logger.info("Oligo length: " + this.getOligoLength());
        logger.info("Oligo interval length: " + this.getOligoIntervalLength());
        logger.info("Genome file: " + this.getGenomeFile());
        logger.info("Genome masked file: " + this.getGenomeMaskedFile());
        logger.info("Output directory: " + this.getOutputDir());
        this.startTimeDesign = System.currentTimeMillis();
        if (!this.getOligosDir().exists() && !this.getOligosDir().mkdirs()) {
            throw new TeolennException("Unable to create oligos directory.");
        }
        if (!this.getTempDir().exists() && !this.getTempDir().mkdirs()) {
            throw new TeolennException("Unable to create temporary directory.");
        }
        FileUtils.removeFiles(this.getTempDir().listFiles(), true);
        OligoSequenceResource.getRessource(this.getOligosDir(), ".oligo", this.getOligoLength(), this.getOligoIntervalLength(), this.isStart1());
    }

    public void phase1CreateAllOligos() throws TeolennException {
        if (this.isSkipPhase1()) {
            return;
        }
        this.logStartPhase("create oligos");
        FileUtils.removeFiles(this.getOligosDir().listFiles(), false);
        Map<String, Integer> chrOligo = null;
        Map<String, Integer> chrMasked = null;
        try {
            chrOligo = SequenceCore.fastaOverlap(this.getGenomeFile(), this.getOligosDir(), ".oligo", this.getOligoLength(), this.getOligoIntervalLength(), this.isStart1());
            if (this.isGenomeMaskedFile()) {
                chrMasked = SequenceCore.fastaOverlap(this.getGenomeMaskedFile(), this.getOligosDir(), ".masked", this.getOligoLength(), this.getOligoIntervalLength(), this.isStart1());
            }
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
        if (this.isGenomeMaskedFile()) {
            this.verifyChromosomeLengths(chrOligo, chrMasked);
        }
        ChromosomeNameResource chromosomeNames = ChromosomeNameResource.getRessource(this.getOligosDir());
        chromosomeNames.addChromosomesNames(chrOligo);
        logger.info("" + this.countOligosCreated(chrOligo) + " oligos created in " + chrOligo.size() + " chromosomes.");
        this.logEndPhase("create oligos");
    }

    public void phase2FilterAllOligos(List<SequenceFilter> listSequenceFilters) throws TeolennException {
        if (this.isSkipPhase2()) {
            return;
        }
        this.logStartPhase("filter oligos");
        FileUtils.removeFiles(FileUtils.listFilesByExtension(this.getOligosDir(), ".oligo.filtered"), false);
        FileUtils.removeFiles(FileUtils.listFilesByExtension(this.getOligosDir(), ".masked.filtered"), false);
        for (SequenceFilter sf : listSequenceFilters) {
            sf.init();
        }
        List<String> chrNames = ChromosomeNameResource.getRessource().getChromosomesNames();
        ArrayList<File> oligoFiles = new ArrayList<File>(chrNames.size());
        File oligoDir = this.getOligosDir();
        for (String chrName : chrNames) {
            oligoFiles.add(new File(oligoDir, chrName + ".oligo"));
        }
        try {
            DesignCommand.filterSequencesFiles(oligoFiles, listSequenceFilters, this.isGenomeMaskedFile());
        }
        catch (IOException e) {
            throw new TeolennException("Error while filtering sequence: " + e.getMessage());
        }
        this.logEndPhase("filter oligos");
    }

    public void phase3CalcMeasurements(List<Measurement> listMeasurements) throws TeolennException {
        if (this.isSkipPhase3()) {
            return;
        }
        this.logStartPhase("calc measurements");
        for (Measurement m : listMeasurements) {
            logger.fine("init measurement: " + m.getName());
            m.init();
        }
        List<String> chrNames = ChromosomeNameResource.getRessource().getChromosomesNames();
        ArrayList<File> oligoFilteredFiles = new ArrayList<File>(chrNames.size());
        File oligoDir = this.getOligosDir();
        String suffix = this.isSkipSequenceFilters() ? ".oligo" : ".oligo.filtered";
        for (String chrName : chrNames) {
            oligoFilteredFiles.add(new File(oligoDir, chrName + suffix));
        }
        if (oligoFilteredFiles == null || oligoFilteredFiles.size() == 0) {
            logger.severe("No file found for oligo measurement computation.");
            throw new RuntimeException("No file found for oligo measurement computation.");
        }
        try {
            File oligoMeasurementsFile = new File(this.getOutputDir(), "oligo.mes");
            File oligoStatsFile = new File(this.getOutputDir(), "oligo.stats");
            MeasurementCore.createMeasurementsFile(oligoFilteredFiles, oligoMeasurementsFile, listMeasurements, oligoStatsFile);
        }
        catch (IOException e) {
            throw new TeolennException("Unable to create measurement file: " + e.getMessage());
        }
        this.logEndPhase("calc measurements");
    }

    public void phase4FilterMeasurements(List<MeasurementFilter> listMeasurementFilters, boolean overvriteStatFile) throws TeolennException {
        if (this.isSkipPhase4()) {
            return;
        }
        this.logStartPhase("filter measurements");
        for (MeasurementFilter mf : listMeasurementFilters) {
            mf.init();
        }
        File filteredOligoMeasurementsFile = new File(this.getOutputDir(), "filtered.mes");
        File statsFile = new File(this.getOutputDir(), "filtered.stats");
        MeasurementCore.filterMeasurementsFile(new File("oligo.mes"), filteredOligoMeasurementsFile, overvriteStatFile ? statsFile : null, listMeasurementFilters);
        this.logEndPhase("filter measurements");
    }

    public void phase5Select(SequenceSelector selector, WeightsSetter wSetter) throws TeolennException {
        this.logStartPhase("select");
        File oligoMeasurementsFile = new File(this.getOutputDir(), "oligo.mes");
        File filteredOligoMeasurementsFile = new File(this.getOutputDir(), "filtered.mes");
        File statsFile = new File(this.getOutputDir(), "filtered.stats");
        File selectedOligos = new File(this.getOutputDir(), "select.mes");
        if (!statsFile.exists()) {
            logger.severe("No stats file found.");
            throw new RuntimeException("No stats file found.");
        }
        logger.info("Use " + selector.getName() + " as selector.");
        selector.setInitParameter("_oriMesFile", oligoMeasurementsFile.getAbsolutePath());
        selector.setInitParameter("_filteredMesFile", filteredOligoMeasurementsFile.getAbsolutePath());
        selector.setInitParameter("_statsFile", statsFile.getAbsolutePath());
        selector.init();
        try {
            SequenceMeasurementsReader measurementReader = SequenceMeasurementsIOFactory.createSequenceMeasurementsFilteredReader(filteredOligoMeasurementsFile, oligoMeasurementsFile);
            MultiSequenceMeasurementWriter measurementWriter = new MultiSequenceMeasurementWriter(new SequenceMeasurementsWriter[0]);
            for (Output o : this.getOutputList()) {
                o.setInitParameter("_outputdefaultfile", selectedOligos.getAbsolutePath());
                o.init();
                measurementWriter.addWriter(o);
            }
            selector.select(measurementReader, measurementWriter, wSetter);
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
        this.logEndPhase("select");
        long endTimeDesign = System.currentTimeMillis();
        logger.info("Process the design in " + StringUtils.toTimeHumanReadable(endTimeDesign - this.startTimeDesign) + " ms.");
    }

    private void logStartPhase(String phaseName) {
        this.startTimeCurrentPhase = System.currentTimeMillis();
        logger.info("Start " + phaseName + " phase.");
    }

    private void logEndPhase(String phaseName) {
        long endTimePhase = System.currentTimeMillis();
        logger.info("Process phase " + phaseName + " in " + StringUtils.toTimeHumanReadable(endTimePhase - this.startTimeCurrentPhase) + " ms.");
    }
}

