/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn;

import fr.ens.transcriptome.teolenn.DesignCommand;
import fr.ens.transcriptome.teolenn.Globals;
import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.WeightsSetter;
import fr.ens.transcriptome.teolenn.measurement.ChromosomeMeasurement;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.measurement.MeasurementRegistery;
import fr.ens.transcriptome.teolenn.measurement.OligoLengthMeasurement;
import fr.ens.transcriptome.teolenn.measurement.OligoStartMeasurement;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilter;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilterRegistery;
import fr.ens.transcriptome.teolenn.output.DefaultOutput;
import fr.ens.transcriptome.teolenn.output.Output;
import fr.ens.transcriptome.teolenn.output.OutputRegistery;
import fr.ens.transcriptome.teolenn.selector.SequenceSelector;
import fr.ens.transcriptome.teolenn.selector.SequenceSelectorRegistery;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceFilter;
import fr.ens.transcriptome.teolenn.sequence.filter.SequenceFilterRegistery;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DesignReader {
    private static Logger logger = Logger.getLogger("Teolenn");
    private DesignCommand design;
    private Properties constants;

    public void readDesign(File designFile, File genomeFile, File genomeMaskedFile, File outputDir) throws TeolennException, IOException, DocumentException {
        Element root;
        this.design = new DesignCommand();
        this.constants = new Properties();
        logger.info("Teolenn version " + Globals.APP_VERSION + " (" + Globals.APP_BUILD_NUMBER + " " + Globals.APP_BUILD_DATE + ")");
        SAXReader saxReader = new SAXReader();
        Document document = saxReader.read((Reader)new FileReader(designFile));
        Element designElement = root = document.getRootElement();
        double designFileVersion = 0.0;
        Iterator i1 = designElement.elementIterator("formatversion");
        while (i1.hasNext()) {
            designFileVersion = Double.parseDouble(((Element)i1.next()).getTextTrim());
        }
        if (designFileVersion != 1.1) {
            System.err.println("Invalid version of your Teolenn design file.");
            System.exit(1);
        }
        this.constants = this.getElementConstants(designElement);
        Iterator i2 = designElement.elementIterator("startposition");
        while (i2.hasNext()) {
            String sp = ((Element)i2.next()).getTextTrim();
            if ("1".equals(sp)) {
                this.design.setStart1(true);
                continue;
            }
            this.design.setStart1(false);
        }
        this.setConstant("startPosition", "" + this.design.isStart1());
        Iterator i3 = designElement.elementIterator("oligolength");
        while (i3.hasNext()) {
            this.design.setOligoLength(Integer.parseInt(this.getValue(i3)));
        }
        this.setConstant("oligolength", "" + this.design.getOligoLength());
        Iterator i4 = designElement.elementIterator("oligointervallength");
        while (i4.hasNext()) {
            this.design.setOligoIntervalLength(Integer.parseInt(this.getValue(i4)));
        }
        this.setConstant("oligointervallength", "" + this.design.getOligoIntervalLength());
        if (genomeFile != null) {
            this.design.setGenomeFile(genomeFile);
        } else {
            Iterator i5 = designElement.elementIterator("genomefile");
            while (i5.hasNext()) {
                this.design.setGenomeFile(new File(this.getValue(i5)));
            }
        }
        this.setConstant("genomefile", "" + this.design.getGenomeFile().getAbsolutePath());
        if (genomeMaskedFile != null) {
            this.design.setGenomeMaskedFile(genomeMaskedFile);
        } else {
            Iterator i6 = designElement.elementIterator("genomemaskedfile");
            while (i6.hasNext()) {
                String filename = this.getValue(i6);
                if ("".equals(filename)) continue;
                this.design.setGenomeMaskedFile(new File(filename));
            }
        }
        this.setConstant("genomemaskedfile", "" + this.design.getGenomeMaskedFile().getAbsolutePath());
        if (outputDir != null) {
            this.design.setOutputDir(outputDir);
        } else {
            Iterator i7 = designElement.elementIterator("outputdir");
            while (i7.hasNext()) {
                String path = this.getValue(i7);
                if ("".equals(path)) continue;
                this.design.setOutputDir(new File(path).getCanonicalFile());
            }
        }
        this.setConstant("outputdir", "" + this.design.getOutputDir().getAbsolutePath());
        if (this.design.getGenomeFile() == null || !this.design.getGenomeFile().isFile()) {
            throw new InvalidParameterException("genome file is not found" + (this.design.getGenomeFile() == null ? "." : ": " + this.design.getGenomeFile()));
        }
        if (this.design.getGenomeMaskedFile() != null && !this.design.getGenomeMaskedFile().isFile()) {
            throw new InvalidParameterException("genome masked file is not found" + (this.design.getGenomeMaskedFile() == null ? "." : ": " + this.design.getGenomeMaskedFile()));
        }
        if (this.design.getOutputDir() == null || !this.design.getOutputDir().isDirectory()) {
            throw new InvalidParameterException("output directory is not found" + (this.design.getOutputDir() == null ? "." : ": " + this.design.getOutputDir()));
        }
        this.isSkipElementEnable(designElement, "sequencefilters");
        DesignCommand d = this.design;
        d.setSkipSequenceCreation(this.isSkipElementEnable(designElement, "sequencecreation"));
        d.setSkipSequenceFilters(this.isSkipElementEnable(designElement, "sequencefilters"));
        d.setSkipMeasurementsComputation(this.isSkipElementEnable(designElement, "measurements"));
        d.setSkipMeasurementsFilters(this.isSkipElementEnable(designElement, "measurementfilters"));
        d.setSkipSelector(this.isSkipElementEnable(designElement, "selector"));
        d.setSequenceFiltersList(this.parseSequenceFilters(designElement));
        d.setMeasurementsList(this.parseMeasurements(designElement));
        d.setMeasurementFiltersList(this.parseMeasurementFilters(designElement));
        d.setSelector(this.parseSelector(designElement));
        d.setWeightSetters(this.parseSelectWeights(designElement));
        d.setOutputsList(this.parseOutput(designElement));
    }

    private void setConstant(String constantName, String constantValue) {
        this.constants.setProperty(constantName, constantValue);
    }

    private String getValue(Iterator i) {
        return this.getValue((Element)i.next());
    }

    private String getValue(Element e) {
        if (e == null) {
            return "";
        }
        return this.getValue(e.getTextTrim());
    }

    private String getValue(String s) {
        String constantName;
        if (s.startsWith("${") && s.endsWith("}") && this.constants.containsKey(constantName = s.substring(2, s.length() - 1))) {
            return this.constants.getProperty(constantName);
        }
        return s;
    }

    private List<SequenceFilter> parseSequenceFilters(Element rootElement) throws IOException {
        ArrayList<SequenceFilter> list = new ArrayList<SequenceFilter>();
        Iterator i = rootElement.elementIterator("sequencefilters");
        while (i.hasNext()) {
            Element filters = (Element)i.next();
            Iterator i2 = filters.elementIterator("sequencefilter");
            while (i2.hasNext()) {
                Element filter = (Element)i2.next();
                String filterName = null;
                Iterator i3 = filter.elementIterator("name");
                while (i3.hasNext()) {
                    Element name = (Element)i3.next();
                    filterName = name.getTextTrim();
                }
                if (filterName == null) {
                    logger.warning("Filter without name.");
                    continue;
                }
                Iterator i4 = filter.elementIterator("class");
                while (i4.hasNext()) {
                    Element clazz = (Element)i4.next();
                    String filterClass = clazz.getTextTrim();
                    SequenceFilterRegistery.addSequenceFilterType(filterName, filterClass);
                }
                Properties properties = this.getElementParameters(filter);
                SequenceFilter f = SequenceFilterRegistery.getSequenceFilter(filterName);
                if (f == null) {
                    logger.warning("Unknown sequence filter: " + filterName);
                    continue;
                }
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    f.setInitParameter((String)entry.getKey(), (String)entry.getValue());
                }
                list.add(f);
            }
        }
        for (SequenceFilter sq : list) {
            this.design.setDefaultModuleInitParameters(sq);
        }
        return list;
    }

    private List<Measurement> parseMeasurements(Element rootElement) throws IOException {
        ArrayList<Measurement> list = new ArrayList<Measurement>();
        list.add(new ChromosomeMeasurement());
        list.add(new OligoStartMeasurement());
        list.add(new OligoLengthMeasurement());
        Iterator i = rootElement.elementIterator("measurements");
        while (i.hasNext()) {
            Element measurements = (Element)i.next();
            Iterator i2 = measurements.elementIterator("measurement");
            while (i2.hasNext()) {
                Element measurement = (Element)i2.next();
                String measurementName = null;
                Iterator i3 = measurement.elementIterator("name");
                while (i3.hasNext()) {
                    Element name = (Element)i3.next();
                    measurementName = name.getTextTrim();
                }
                if (measurementName == null) {
                    logger.warning("Measurement without name.");
                    continue;
                }
                if ("Chromosome".toLowerCase().equals(measurementName.toLowerCase()) || "OligoStart".toLowerCase().equals(measurementName.toLowerCase())) continue;
                Iterator i4 = measurement.elementIterator("class");
                while (i4.hasNext()) {
                    Element clazz = (Element)i4.next();
                    String measurementClass = clazz.getTextTrim();
                    MeasurementRegistery.addMeasurementType(measurementName, measurementClass);
                }
                Properties properties = this.getElementParameters(measurement);
                Measurement m = MeasurementRegistery.getMeasurement(measurementName);
                if (m == null) {
                    logger.warning("Unknown measurement: " + measurementName);
                    continue;
                }
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    m.setInitParameter((String)entry.getKey(), (String)entry.getValue());
                }
                list.add(m);
            }
        }
        for (Measurement m : list) {
            this.design.setDefaultModuleInitParameters(m);
        }
        return list;
    }

    private List<MeasurementFilter> parseMeasurementFilters(Element rootElement) throws IOException {
        ArrayList<MeasurementFilter> list = new ArrayList<MeasurementFilter>();
        Iterator i = rootElement.elementIterator("measurementfilters");
        while (i.hasNext()) {
            Element filters = (Element)i.next();
            Iterator i2 = filters.elementIterator("measurementfilter");
            while (i2.hasNext()) {
                Element filter = (Element)i2.next();
                String measurementFilterName = null;
                Iterator i3 = filter.elementIterator("name");
                while (i3.hasNext()) {
                    Element name = (Element)i3.next();
                    measurementFilterName = name.getTextTrim();
                }
                if (measurementFilterName == null) {
                    logger.warning("Measurement filter without name.");
                    continue;
                }
                Iterator i4 = filter.elementIterator("class");
                while (i4.hasNext()) {
                    Element clazz = (Element)i4.next();
                    String measurementClass = clazz.getTextTrim();
                    MeasurementFilterRegistery.addMeasurementFilterType(measurementFilterName, measurementClass);
                }
                Properties properties = this.getElementParameters(filter);
                MeasurementFilter mf = MeasurementFilterRegistery.getMeasuremrentFilter(measurementFilterName);
                if (mf == null) {
                    logger.warning("Unknown measurement: " + measurementFilterName);
                    continue;
                }
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    mf.setInitParameter((String)entry.getKey(), (String)entry.getValue());
                }
                list.add(mf);
            }
        }
        for (MeasurementFilter mf : list) {
            this.design.setDefaultModuleInitParameters(mf);
        }
        return list;
    }

    private SequenceSelector parseSelector(Element rootElement) throws TeolennException {
        Iterator i = rootElement.elementIterator("selector");
        if (i.hasNext()) {
            Element selector = (Element)i.next();
            String selectorName = null;
            Iterator i1 = selector.elementIterator("name");
            while (i1.hasNext()) {
                Element name = (Element)i1.next();
                selectorName = name.getTextTrim();
            }
            Iterator i2 = selector.elementIterator("class");
            while (i2.hasNext()) {
                Element clazz = (Element)i2.next();
                String selectorClass = clazz.getTextTrim();
                SequenceSelectorRegistery.addSequenceSelectorType(selectorName, selectorClass);
            }
            Properties properties = this.getElementParameters(selector);
            SequenceSelector s = SequenceSelectorRegistery.getSequenceSelector(selectorName);
            if (s == null) {
                logger.warning("Unknown selector: " + selectorName);
                throw new TeolennException("Unknown selector: " + selectorName);
            }
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                s.setInitParameter((String)entry.getKey(), (String)entry.getValue());
            }
            this.design.setDefaultModuleInitParameters(s);
            return s;
        }
        throw new TeolennException("No selector found.");
    }

    private WeightsSetter parseSelectWeights(Element rootElement) throws IOException {
        final HashMap<String, Float> selectWeights = new HashMap<String, Float>();
        final HashMap<String, Properties> selectProperties = new HashMap<String, Properties>();
        Iterator i = rootElement.elementIterator("selector");
        while (i.hasNext()) {
            Element select = (Element)i.next();
            Iterator i2 = select.elementIterator("measurement");
            while (i2.hasNext()) {
                Element measurement = (Element)i2.next();
                String measurementName = null;
                String measurementWeight = null;
                Iterator i3 = measurement.elementIterator("name");
                while (i3.hasNext()) {
                    Element name = (Element)i3.next();
                    measurementName = name.getTextTrim();
                }
                if (measurementName == null) {
                    logger.warning("Measurement without name.");
                    continue;
                }
                Iterator i4 = measurement.elementIterator("weight");
                while (i4.hasNext()) {
                    Element weight = (Element)i4.next();
                    measurementWeight = weight.getTextTrim();
                }
                try {
                    selectWeights.put(measurementName, Float.valueOf(Float.parseFloat(measurementWeight)));
                }
                catch (NumberFormatException e) {
                    logger.warning("Invalid " + measurementName + " weight: " + measurementWeight);
                }
                selectProperties.put(measurementName, this.getElementParameters(measurement));
            }
        }
        return new WeightsSetter(){

            public void setWeights(SequenceMeasurements sm) {
                for (Map.Entry e : selectWeights.entrySet()) {
                    sm.setWeight(sm.getMeasurement((String)e.getKey()), ((Float)e.getValue()).floatValue());
                }
                for (Map.Entry e : selectProperties.entrySet()) {
                    String name = (String)e.getKey();
                    Properties properties = (Properties)e.getValue();
                    if (!sm.isMeasurement(name)) {
                        logger.warning("Unknown measurement: " + name);
                        continue;
                    }
                    for (Map.Entry<Object, Object> e2 : properties.entrySet()) {
                        sm.getMeasurement(name).setProperty((String)e2.getKey(), (String)e2.getValue());
                    }
                }
            }
        };
    }

    private List<Output> parseOutput(Element rootElement) throws TeolennException {
        ArrayList<Output> list = new ArrayList<Output>();
        Iterator i = rootElement.elementIterator("outputs");
        while (i.hasNext()) {
            Element outputs = (Element)i.next();
            Iterator i1 = outputs.elementIterator("output");
            while (i1.hasNext()) {
                Element output = (Element)i1.next();
                String selectorName = null;
                Iterator i2 = output.elementIterator("name");
                while (i2.hasNext()) {
                    Element name = (Element)i2.next();
                    selectorName = name.getTextTrim();
                }
                Iterator i3 = output.elementIterator("class");
                while (i3.hasNext()) {
                    Element clazz = (Element)i3.next();
                    String outputClass = clazz.getTextTrim();
                    OutputRegistery.addOutputType(selectorName, outputClass);
                }
                Properties properties = this.getElementParameters(output);
                Output o = OutputRegistery.getOutput(selectorName);
                if (output == null) {
                    logger.warning("Unknown output: " + selectorName);
                    throw new TeolennException("Unknown output: " + selectorName);
                }
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    o.setInitParameter((String)entry.getKey(), (String)entry.getValue());
                }
                list.add(o);
            }
        }
        if (list.size() == 0) {
            list.add(new DefaultOutput());
        }
        for (Output o : list) {
            this.design.setDefaultModuleInitParameters(o);
        }
        return list;
    }

    private final Properties getElementParameters(Element element) {
        Properties result = new Properties();
        Iterator i4 = element.elementIterator("parameters");
        while (i4.hasNext()) {
            Element params = (Element)i4.next();
            Iterator i5 = params.elementIterator("parameter");
            while (i5.hasNext()) {
                Element param = (Element)i5.next();
                String pKey = null;
                String pValue = null;
                Iterator i6 = param.elementIterator("name");
                while (i6.hasNext()) {
                    Element name = (Element)i6.next();
                    pKey = name.getTextTrim().toLowerCase();
                }
                Iterator i7 = param.elementIterator("value");
                while (i7.hasNext()) {
                    Element value = (Element)i7.next();
                    pValue = this.getValue(value.getTextTrim());
                }
                if (pKey == null || pValue == null) continue;
                result.setProperty(pKey, pValue);
            }
        }
        return result;
    }

    private final Properties getElementConstants(Element element) {
        Properties result = new Properties();
        Iterator i4 = element.elementIterator("constants");
        while (i4.hasNext()) {
            Element params = (Element)i4.next();
            Iterator i5 = params.elementIterator("constant");
            while (i5.hasNext()) {
                Element param = (Element)i5.next();
                String pKey = null;
                String pValue = null;
                Iterator i6 = param.elementIterator("name");
                while (i6.hasNext()) {
                    Element name = (Element)i6.next();
                    pKey = name.getTextTrim().toLowerCase();
                }
                Iterator i7 = param.elementIterator("value");
                while (i7.hasNext()) {
                    Element value = (Element)i7.next();
                    pValue = value.getTextTrim();
                }
                if (pKey == null && pValue == null) continue;
                result.setProperty(pKey, pValue);
            }
        }
        return result;
    }

    private final boolean isSkipElementEnable(Element rootElement, String elementName) {
        boolean result = false;
        Iterator i = rootElement.elementIterator(elementName);
        while (i.hasNext()) {
            Element e = (Element)i.next();
            String value = e.attributeValue("skip");
            if (value == null) {
                return false;
            }
            result = Boolean.parseBoolean(value.trim());
        }
        return result;
    }

    public DesignCommand getDesign() {
        return this.design;
    }
}

