/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class Globals {
    private static Properties manifestProperties;
    private static final String MANIFEST_PROPERTIES_FILE = "/manifest.txt";
    public static final String APP_NAME = "Teolenn";
    public static final String APP_NAME_LOWER_CASE;
    public static final String APP_VERSION;
    public static final String APP_BUILD_NUMBER;
    public static final String APP_BUILD_DATE;
    public static final Level LOG_LEVEL;
    public static final boolean DEBUG = false;
    public static final boolean MEASUREMENT_FILE_SERIALIZED = true;
    public static final Formatter LOG_FORMATTER;
    private static final String WEBSITE_URL_DEFAULT = "http://transcriptome.ens.fr/teolenn";
    public static final String WEBSITE_URL;
    private static final String COPYRIGHT_DATE = "2008-2009";
    public static final String LICENSE_TXT = "This program is developed under the GNU General Public License version 2 or later and CeCILL.";
    public static final String ABOUT_TXT;
    public static final boolean STD_OUTPUT_DEFAULT = false;
    public static final double DESIGN_FILE_VERSION = 1.1;

    private static String getVersion() {
        String s = Globals.getManifestProperty("Specification-Version");
        return s != null ? s : "UNKNOWN_VERSION";
    }

    private static String getBuiltNumber() {
        String s = Globals.getManifestProperty("Implementation-Version");
        return s != null ? s : "UNKNOWN_BUILT";
    }

    private static String getBuiltDate() {
        String unknown = "UNKNOWN_DATE";
        String s = Globals.getManifestProperty("Built-Date");
        return s != null ? s : "UNKNOWN_DATE";
    }

    private static String getWebSiteURL() {
        String s = Globals.getManifestProperty("url");
        return s != null ? s : WEBSITE_URL_DEFAULT;
    }

    private static String getManifestProperty(String propertyKey) {
        if (propertyKey == null) {
            return null;
        }
        Globals.readManifest();
        return manifestProperties.getProperty(propertyKey);
    }

    private static synchronized void readManifest() {
        if (manifestProperties != null) {
            return;
        }
        try {
            manifestProperties = new Properties();
            InputStream is = Globals.class.getResourceAsStream(MANIFEST_PROPERTIES_FILE);
            if (is == null) {
                return;
            }
            manifestProperties.load(is);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Globals() {
    }

    static {
        APP_NAME_LOWER_CASE = APP_NAME.toLowerCase();
        APP_VERSION = Globals.getVersion();
        APP_BUILD_NUMBER = Globals.getBuiltNumber();
        APP_BUILD_DATE = Globals.getBuiltDate();
        LOG_LEVEL = Level.INFO;
        LOG_FORMATTER = new Formatter(){

            public String format(LogRecord record) {
                return record.getLevel() + "\t" + record.getMessage() + "\n";
            }
        };
        WEBSITE_URL = Globals.getWebSiteURL();
        ABOUT_TXT = "Teolenn version " + APP_VERSION + " (" + APP_BUILD_NUMBER + ")" + " is a software to compute design of oligonucleotides for microarrays.\n" + "This version has been built on " + APP_BUILD_DATE + ".\n\n" + "Authors:\n" + "  Laurent Jourdren <jourdren@biologie.ens.fr>\n" + "  St\u00e9phane Le Crom <lecrom@biologie.ens.fr>\n" + "Contacts:\n" + "  Mail: " + APP_NAME_LOWER_CASE + "@biologie.ens.fr\n" + "  Google group: http://groups.google.com/group/teolenn\n" + "Copyright " + COPYRIGHT_DATE + " \u00c9cole Normale Sup\u00e9rieure microarray platform.\n" + LICENSE_TXT + "\n";
    }
}

