/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn;

import fr.ens.transcriptome.teolenn.DesignReader;
import fr.ens.transcriptome.teolenn.Globals;
import fr.ens.transcriptome.teolenn.Settings;
import java.io.File;
import java.io.IOException;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dom4j.DocumentException;

public class Main {
    private static Logger logger = Logger.getLogger("Teolenn");

    private static void version() {
        System.out.println("Teolenn version " + Globals.APP_VERSION + " (" + Globals.APP_BUILD_NUMBER + " on " + Globals.APP_BUILD_DATE + ")");
        System.exit(0);
    }

    private static void about() {
        System.out.println(Globals.ABOUT_TXT);
        System.exit(0);
    }

    private static void license() {
        System.out.println("This program is developed under the GNU General Public License version 2 or later and CeCILL.");
        System.exit(0);
    }

    private static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Globals.APP_NAME_LOWER_CASE + " [options] design [genome [genome_masked [output_dir]]]", options);
        System.exit(0);
    }

    private static Options makeOptions() {
        Options options = new Options();
        options.addOption("version", false, "show version of the software");
        options.addOption("about", false, "display information about this software");
        options.addOption("h", "help", false, "display this help");
        options.addOption("license", false, "display information about the license of this software");
        options.addOption("v", "verbose", false, "display external tools output");
        options.addOption("silent", false, "don't show log on console");
        OptionBuilder.withArgName((String)"number");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"number of threads to use");
        options.addOption(OptionBuilder.create((String)"threads"));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"configuration file to use");
        options.addOption(OptionBuilder.create((String)"conf"));
        OptionBuilder.withArgName((String)"file");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"external log file");
        options.addOption(OptionBuilder.create((String)"log"));
        OptionBuilder.withArgName((String)"level");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)"log level");
        options.addOption(OptionBuilder.create((String)"loglevel"));
        return options;
    }

    private static int parseCommandLine(String[] args) {
        Options options = Main.makeOptions();
        GnuParser parser = new GnuParser();
        int argsOptions = 0;
        try {
            CommandLine line = parser.parse(options, args);
            if (line.hasOption("help")) {
                Main.help(options);
            }
            if (line.hasOption("about")) {
                Main.about();
            }
            if (line.hasOption("version")) {
                Main.version();
            }
            if (line.hasOption("license")) {
                Main.license();
            }
            try {
                if (line.hasOption("conf")) {
                    Settings.loadSettings(new File(line.getOptionValue("conf")));
                    argsOptions += 2;
                } else {
                    Settings.loadSettings();
                }
            }
            catch (IOException e) {
                logger.severe("Error while reading configuration file.");
                System.exit(1);
            }
            if (line.hasOption("threads")) {
                try {
                    argsOptions += 2;
                    Settings.setMaxthreads(Integer.parseInt(line.getOptionValue("threads")));
                }
                catch (NumberFormatException e) {
                    logger.warning("Invalid threads number");
                }
            }
            if (line.hasOption("verbose")) {
                Settings.setStandardOutputForExecutable(true);
                ++argsOptions;
            }
            if (line.hasOption("log")) {
                argsOptions += 2;
                try {
                    FileHandler fh = new FileHandler(line.getOptionValue("log"));
                    fh.setFormatter(Globals.LOG_FORMATTER);
                    logger.setUseParentHandlers(false);
                    logger.addHandler(fh);
                }
                catch (IOException e) {
                    logger.severe("Error while creating log file: " + e.getMessage());
                    System.exit(1);
                }
            }
            if (line.hasOption("silent")) {
                logger.setUseParentHandlers(false);
            }
            if (line.hasOption("loglevel")) {
                argsOptions += 2;
                try {
                    logger.setLevel(Level.parse(line.getOptionValue("loglevel").toUpperCase()));
                }
                catch (IllegalArgumentException e) {
                    logger.warning("Unknown log level (" + line.getOptionValue("loglevel") + "). Accepted values are [SEVERE, WARNING, INFO, CONFIG, FINE, FINER, FINEST].");
                }
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
        catch (SecurityException e) {
            logger.severe(e.getMessage());
            System.exit(1);
        }
        if (argsOptions == args.length) {
            System.err.println("No inputs files.");
            System.err.println("type: " + Globals.APP_NAME_LOWER_CASE + " -h for more informations.");
            System.exit(1);
        }
        return argsOptions;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        logger.setLevel(Globals.LOG_LEVEL);
        logger.getParent().getHandlers()[0].setFormatter(Globals.LOG_FORMATTER);
        int argsOptions = Main.parseCommandLine(args);
        File designFile = new File(args[argsOptions + 0]);
        File genomeFile = args.length > argsOptions + 1 ? new File(args[argsOptions + 1]) : null;
        File genomeMaskedFile = args.length > argsOptions + 2 ? new File(args[argsOptions + 2]) : null;
        File outputDir = args.length > argsOptions + 3 ? new File(args[argsOptions + 3]) : null;
        try {
            DesignReader designReader = new DesignReader();
            designReader.readDesign(designFile, genomeFile, genomeMaskedFile, outputDir);
            designReader.getDesign().execute();
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            System.exit(1);
        }
    }
}

