/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn;

import fr.ens.transcriptome.teolenn.Globals;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Logger;

public class Settings {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static Properties properties = new Properties();

    public static String getSoapPath() {
        return properties.getProperty("soap.path");
    }

    public static String getGenomeToolsPath() {
        return properties.getProperty("gt.path");
    }

    public static boolean isStandardOutputForExecutable() {
        return Boolean.parseBoolean(properties.getProperty("std.output"));
    }

    public static int getMaxThreads() {
        return Integer.parseInt(properties.getProperty("max.threads"));
    }

    public static boolean isMeasurementFileSerialized() {
        return Boolean.parseBoolean(properties.getProperty("mes.serialized.format"));
    }

    public static void setSoapPath(String soapPath) {
        properties.setProperty("soap.path", soapPath);
    }

    public static void setGenomeToolsPath(String gtPath) {
        properties.setProperty("gt.path", gtPath);
    }

    public static void setStandardOutputForExecutable(boolean stdOutput) {
        properties.setProperty("std.output", Boolean.toString(stdOutput));
    }

    public static void setMaxthreads(int maxThreads) {
        if (maxThreads < 1) {
            return;
        }
        properties.setProperty("max.threads", Integer.toString(maxThreads));
    }

    public static void setMeasurementFileSerialized(boolean serialized) {
        properties.setProperty("mes.serialized.format", Boolean.toString(serialized));
    }

    public static String getConfigurationFilePath() {
        String os = System.getProperty("os.name");
        String home = System.getProperty("user.home");
        if (os.toLowerCase().startsWith("windows")) {
            return home + File.separator + "Application Data" + File.separator + Globals.APP_NAME_LOWER_CASE + ".conf";
        }
        return home + File.separator + "." + Globals.APP_NAME_LOWER_CASE;
    }

    public static void saveSettings() throws IOException {
        Settings.saveSettings(new File(Settings.getConfigurationFilePath()));
    }

    public static void saveSettings(File file) throws IOException {
        FileOutputStream fos = new FileOutputStream(file);
        properties.store(fos, " Teolenn version " + Globals.APP_VERSION + " configuration file");
        fos.close();
    }

    public static void loadSettings() throws IOException {
        File confFile = new File(Settings.getConfigurationFilePath());
        if (!confFile.exists()) {
            logger.config("No configuration file found.");
        } else {
            Settings.loadSettings(confFile);
        }
    }

    public static void loadSettings(File file) throws IOException {
        logger.info("Load configuration file: " + file.getAbsolutePath());
        FileInputStream fis = new FileInputStream(file);
        properties.load(fis);
        fis.close();
    }

    static {
        Settings.setStandardOutputForExecutable(false);
        Runtime runtime = Runtime.getRuntime();
        Settings.setMaxthreads(runtime.availableProcessors());
        Settings.setMeasurementFileSerialized(true);
    }
}

