/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.core;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilter;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsIOFactory;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsWriter;
import fr.ens.transcriptome.teolenn.sequence.SequenceIterator;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurementsStatWriter;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementCore {
    private static final Logger logger = Logger.getLogger("Teolenn");

    public static final void createMeasurementsFile(List<File> inputFiles, File measurementsFile, List<Measurement> measurements, File statsFile) throws IOException {
        if (inputFiles == null || inputFiles.size() == 0) {
            return;
        }
        SequenceMeasurementsWriter smw = SequenceMeasurementsIOFactory.createSequenceMeasurementsWriter(measurementsFile);
        SequenceMeasurements sm = new SequenceMeasurements();
        if (measurements != null) {
            for (Measurement m : measurements) {
                sm.addMesurement(m);
            }
        }
        int id = 0;
        for (File inputFile : inputFiles) {
            id = MeasurementCore.createMeasurementsFile(inputFile, smw, sm, id, true);
        }
        smw.close();
        if (statsFile != null) {
            logger.fine("Create measurement stats file.");
            SequenceMeasurementsStatWriter smsw = new SequenceMeasurementsStatWriter(statsFile);
            smsw.write(sm);
        }
        logger.info("Create " + id + " entries in measurement file.");
    }

    private static final int createMeasurementsFile(File inputFile, SequenceMeasurementsWriter smw, SequenceMeasurements sm, int idStart, boolean addStats) throws IOException {
        SequenceIterator si = new SequenceIterator(inputFile);
        int count = idStart;
        for (Measurement m : sm.getMeasurements()) {
            m.setProperty("currentOligoFile", inputFile.getAbsolutePath());
        }
        while (si.hasNext()) {
            si.next();
            sm.setId(++count);
            sm.setSequence(si);
            sm.calcMesurements();
            if (addStats) {
                sm.addMesurementsToStats();
            }
            smw.writeSequenceMesurement(sm);
        }
        return count;
    }

    public static final void filterMeasurementsFile(File measurementsFile, File filteredMeasurementsFile, File statsFile, List<MeasurementFilter> filters) throws TeolennException {
        try {
            SequenceMeasurementsReader smr = SequenceMeasurementsIOFactory.createSequenceMeasurementsReader(measurementsFile);
            SequenceMeasurementsWriter smw = SequenceMeasurementsIOFactory.createSequenceMeasurementsFilteredWriter(filteredMeasurementsFile, measurementsFile);
            int count = -1;
            SequenceMeasurements sm = null;
            SequenceMeasurements last = null;
            while ((sm = smr.next(sm)) != null) {
                if (count == -1) {
                    for (Measurement m : sm.getMeasurements()) {
                        m.clear();
                    }
                    count = 0;
                }
                boolean pass = true;
                for (MeasurementFilter filter : filters) {
                    if (filter.accept(sm)) continue;
                    pass = false;
                    break;
                }
                if (pass) {
                    sm.addMesurementsToStats();
                    smw.writeSequenceMesurement(sm);
                    ++count;
                }
                last = sm;
            }
            smr.close();
            smw.close();
            logger.info("" + count + " entries found for measurement after filtering.");
            if (statsFile != null) {
                logger.fine("Write stats file for measurements.");
                SequenceMeasurementsStatWriter smsw = new SequenceMeasurementsStatWriter(statsFile);
                smsw.write(last);
            }
        }
        catch (IOException e) {
            throw new TeolennException("IO Error while filtering measurements: " + e.getMessage());
        }
    }
}

