/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.core;

import fr.ens.transcriptome.teolenn.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceCore {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static final int FASTA_MAX_LEN = 70;
    private static final int WRITE_BUFFER_LEN = 1000000;
    private static final StringBuilder outputStringBuilder = new StringBuilder(1050000);

    public static final Map<String, Integer> fastaOverlap(File inputFile, File outputDir, String extension, int windowSize, int interval, boolean start1) throws IOException {
        String line;
        int firstPosition;
        int minSize = windowSize - interval <= 0 ? 1 : windowSize - interval;
        int maxSize = windowSize + interval;
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        BufferedReader br = null;
        try {
            br = FileUtils.createBufferedReader(inputFile);
        }
        catch (FileNotFoundException e) {
            logger.severe("Unable to read file: " + e.getMessage());
            throw e;
        }
        boolean first = true;
        StringBuilder sbHeader = new StringBuilder();
        String outputFilename = null;
        String headerOutput = null;
        Writer os = null;
        int countInternal = 0;
        int count = 0;
        StringBuilder subSeq = new StringBuilder(maxSize);
        int offset = firstPosition = start1 ? 1 : 0;
        while ((line = br.readLine()) != null) {
            String lineTrimed = line.trim();
            if (line.startsWith(">")) {
                if (!first) {
                    SequenceCore.writeAllSubSeq(subSeq, os, offset, minSize, maxSize, headerOutput, true);
                    result.put(outputFilename, count);
                    count = 0;
                    offset = firstPosition;
                    countInternal = subSeq.length();
                } else {
                    first = false;
                }
                outputFilename = lineTrimed.substring(1).replace(' ', '_');
                try {
                    os = SequenceCore.getOutputStream(outputDir, outputFilename, extension);
                }
                catch (FileNotFoundException e) {
                    logger.severe("Unable to create file: " + e.getMessage());
                    throw e;
                }
                sbHeader.append(lineTrimed);
                sbHeader.append(":subseq(");
                headerOutput = sbHeader.toString();
                sbHeader.setLength(0);
                continue;
            }
            int lineLength = lineTrimed.length();
            subSeq.append(line);
            count += lineLength;
            if ((countInternal += lineLength) <= maxSize) continue;
            offset += SequenceCore.writeAllSubSeq(subSeq, os, offset, minSize, maxSize, headerOutput, false);
            countInternal = 0;
        }
        SequenceCore.writeAllSubSeq(subSeq, os, offset, minSize, maxSize, headerOutput, true);
        result.put(outputFilename, count);
        br.close();
        return result;
    }

    private static final int writeAllSubSeq(StringBuilder sb, Writer os, int offset, int minSize, int maxSize, String header, boolean flush) throws IOException {
        int endFor = sb.length() - maxSize + 1;
        int index = 0;
        StringBuilder output = outputStringBuilder;
        for (index = 0; index < endFor; ++index) {
            for (int size = minSize; size <= maxSize; ++size) {
                int end = index + size;
                String sequence = sb.substring(index, end);
                SequenceCore.writeSeq(output, sequence, header, offset + index, size);
            }
            if (output.length() <= 1000000) continue;
            os.write(output.toString());
            output.setLength(0);
        }
        if (flush) {
            int endFor2 = sb.length() - minSize + 1;
            int i = 0;
            while (index < endFor2) {
                for (int size = minSize; size < maxSize - i && index < endFor2; ++size) {
                    int end = index + size;
                    String sequence = sb.substring(index, end);
                    SequenceCore.writeSeq(output, sequence, header, offset + index, size);
                }
                ++i;
                ++index;
            }
            os.write(output.toString());
            output.setLength(0);
            os.close();
            sb.setLength(0);
        } else {
            sb.delete(0, index);
        }
        return index;
    }

    private static final void writeSeq(StringBuilder sb, String sequence, String header, int start, int size) throws IOException {
        sb.append(header);
        sb.append(start);
        sb.append(",");
        sb.append(size);
        sb.append(")\n");
        int seqLen = sequence.length();
        for (int i = 0; i < seqLen; i += 70) {
            int endPos = i + 70;
            sb.append(sequence.subSequence(i, endPos > seqLen ? seqLen : endPos));
            sb.append("\n");
        }
    }

    private static final Writer getOutputStream(File outputDir, String prefix, String suffix) throws FileNotFoundException {
        File f = new File(outputDir, prefix + suffix);
        return FileUtils.createBufferedWriter(f);
    }

    public static void fastaExplode(File inputFile, File outputDir, String prefix, String suffix, boolean convertXN, boolean compress) throws IOException {
        String line;
        BufferedReader br = FileUtils.createBufferedReader(inputFile);
        Writer os = null;
        boolean first = true;
        while ((line = br.readLine()) != null) {
            if (first || line.startsWith(">")) {
                if (os != null) {
                    os.close();
                }
                String seqName = line.substring(1, line.length()).trim();
                os = SequenceCore.getOutputStream(outputDir, prefix, seqName, suffix, compress);
                first = false;
            } else if (convertXN) {
                line = line.replace('X', 'N');
            }
            os.write(line);
            os.write("\n");
        }
        os.close();
        br.close();
    }

    private static Writer getOutputStream(File outputDir, String prefix, String seqName, String suffix, boolean compress) throws IOException {
        File f = new File(outputDir, prefix + seqName + suffix);
        return compress ? FileUtils.createBufferedGZipWriter(f) : FileUtils.createBufferedWriter(f);
    }
}

