/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement;

import fr.ens.transcriptome.teolenn.measurement.FloatMeasurement;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import fr.ens.transcriptome.teolenn.sequence.SequenceIterator;
import fr.ens.transcriptome.teolenn.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class ComplexityMeasurement
extends FloatMeasurement {
    private static Logger logger = Logger.getLogger("Teolenn");
    public static final String MEASUREMENT_NAME = "Complexity";
    private static final char[] MASK_BASES = new char[]{'a', 'c', 'g', 't', 'n', 'N', 'x', 'X'};
    private SequenceIterator si;
    private static final Pattern subseqPattern = Pattern.compile("subseq");

    private static final int countChar(String s, char c) {
        if (s == null) {
            return 0;
        }
        int len = s.length();
        int count = 0;
        for (int i = 0; i < len; ++i) {
            if (s.charAt(i) != c) continue;
            ++count;
        }
        return count;
    }

    public float calcFloatMeasurement(Sequence sequence) {
        if (!this.si.hasNext()) {
            throw new RuntimeException("Invalid oligo masked  sequence file: no more sequences");
        }
        this.si.next();
        if (!this.isSameSequencePosition(sequence, this.si)) {
            throw new RuntimeException("Invalid oligo masked  sequence file, sequence not found (" + sequence.getName() + ")");
        }
        String s = this.si.getSequence();
        int maskNumber = 0;
        for (int i = 0; i < MASK_BASES.length; ++i) {
            maskNumber += ComplexityMeasurement.countChar(s, MASK_BASES[i]);
        }
        float result = 1.0f - (float)maskNumber / (float)s.length();
        return result;
    }

    private boolean isSameSequencePosition(Sequence seqA, Sequence seqB) {
        String nameA = seqA.getName();
        String nameB = seqB.getName();
        if (nameA == null || nameB == null) {
            return false;
        }
        String[] splitA = subseqPattern.split(nameA);
        String[] splitB = subseqPattern.split(nameB);
        return splitA[splitA.length - 1].equals(splitB[splitB.length - 1]);
    }

    public String getDescription() {
        return "Complexity measurement";
    }

    public String getName() {
        return MEASUREMENT_NAME;
    }

    public void setProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if ("currentOligoFile".equals(key)) {
            String ext = ".oligo.filtered".equals(StringUtils.extension(value)) ? ".masked.filtered" : ".masked";
            File f = new File(StringUtils.basename(value) + ext);
            logger.fine("Open sequence file: " + f.getName() + " in " + MEASUREMENT_NAME + " measurement.");
            if (!f.exists()) {
                throw new RuntimeException("Unable to open oligo masked  sequence file: " + f.getName());
            }
            try {
                this.si = new SequenceIterator(f);
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to open oligo masked  sequence file: " + f.getName());
            }
        }
        super.setProperty(key, value);
    }

    public float getScore(Object value) {
        return ((Float)value).floatValue();
    }

    public ComplexityMeasurement() {
        super(0.0, 1.0);
    }
}

