/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import fr.ens.transcriptome.teolenn.util.Histogram;
import fr.ens.transcriptome.teolenn.util.MathUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FloatMeasurement
implements Measurement {
    private static final int MAX_STATS_VALUES = 20000;
    private float lastValue = Float.NaN;
    private double[] values = new double[20000];
    private int nValues;
    private double median;
    private double mean;
    private double stdDev;
    private double reference;
    private double deviation;
    private int n;
    private List<Float> listMedian;
    private List<Float> listMean;
    private List<Float> listStdDev;
    private float min = Float.NaN;
    private float max = Float.NaN;
    private Histogram histo;
    private boolean firstGetScore = true;

    protected abstract float calcFloatMeasurement(Sequence var1);

    @Override
    public Object calcMesurement(Sequence sequence) {
        Float result = Float.valueOf(this.calcFloatMeasurement(sequence));
        this.lastValue = result.floatValue();
        return result;
    }

    @Override
    public void addLastMeasurementToStats() {
        this.values[this.nValues++] = this.lastValue;
        if (this.nValues == 20000) {
            this.subStats();
        }
        this.histo.addValue(this.lastValue);
        ++this.n;
        this.min = Float.isNaN(this.min) ? this.lastValue : Math.min(this.lastValue, this.min);
        this.max = Float.isNaN(this.max) ? this.lastValue : Math.max(this.lastValue, this.max);
    }

    private void subStats() {
        double[] array;
        if (this.nValues == 20000) {
            array = this.values;
        } else {
            array = new double[this.nValues];
            System.arraycopy(this.values, 0, array, 0, this.nValues);
        }
        float median = (float)MathUtils.median(array);
        float mean = (float)MathUtils.mean(array);
        float sd = (float)MathUtils.sdFast(array);
        if (this.listMedian == null) {
            this.listMedian = new ArrayList<Float>();
        }
        if (this.listMean == null) {
            this.listMean = new ArrayList<Float>();
        }
        if (this.listStdDev == null) {
            this.listStdDev = new ArrayList<Float>();
        }
        this.listMean.add(Float.valueOf(mean));
        this.listMedian.add(Float.valueOf(median));
        this.listStdDev.add(Float.valueOf(sd));
        this.nValues = 0;
    }

    private float getMean(List<Float> data) {
        double[] array = MathUtils.toArray(data);
        return (float)MathUtils.mean(array);
    }

    @Override
    public Object getType() {
        return Float.class;
    }

    @Override
    public Object parse(String s) {
        if (s == null) {
            return null;
        }
        Float result = Float.valueOf(Float.parseFloat(s));
        this.lastValue = result.floatValue();
        return result;
    }

    private void beforeFirstGetScore() {
        if (Double.isNaN(this.deviation)) {
            this.deviation = this.stdDev;
        }
        if (Double.isNaN(this.reference)) {
            this.reference = this.median;
        }
        this.firstGetScore = false;
    }

    @Override
    public float getScore(Object value) {
        if (this.firstGetScore) {
            this.beforeFirstGetScore();
        }
        double val = ((Float)value).doubleValue();
        return (float)(1.0 - Math.abs((this.reference - val) / this.deviation));
    }

    @Override
    public Properties computeStatistics() {
        if (this.listMean == null || this.listMean.size() == 0) {
            this.subStats();
        }
        this.median = this.getMean(this.listMedian);
        this.mean = this.getMean(this.listMean);
        this.stdDev = this.getMean(this.listStdDev);
        Properties result = new Properties();
        result.setProperty("median", Double.toString(this.median));
        result.setProperty("mean", Double.toString(this.mean));
        result.setProperty("stddev", Double.toString(this.stdDev));
        result.setProperty("n", Integer.toString(this.n));
        result.setProperty("min", Float.toString(this.min));
        result.setProperty("max", Float.toString(this.max));
        double[] histo = this.histo.getHistogram();
        if (histo != null) {
            for (int i = 0; i < histo.length; ++i) {
                result.setProperty("" + i * 10 + "-" + (i + 1) * 10, Double.toString(histo[i]));
            }
        }
        return result;
    }

    @Override
    public void clear() {
        if (this.values != null) {
            this.nValues = 0;
        }
        if (this.listMean != null) {
            this.listMean.clear();
        }
        if (this.listMedian != null) {
            this.listMean.clear();
        }
        if (this.listStdDev != null) {
            this.listStdDev.clear();
        }
        this.min = Float.NaN;
        this.max = Float.NaN;
        this.mean = Double.NaN;
        this.median = Double.NaN;
        this.stdDev = Double.NaN;
        this.reference = Double.NaN;
        this.deviation = Double.NaN;
        this.n = 0;
        this.firstGetScore = true;
    }

    @Override
    public void setProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if ("median".equals(key.trim().toLowerCase())) {
            this.median = Double.parseDouble(value.trim());
        } else if ("mean".equals(key.trim().toLowerCase())) {
            this.mean = Double.parseDouble(value.trim());
        } else if ("stdDev".equals(key.trim().toLowerCase())) {
            this.stdDev = Double.parseDouble(value.trim());
        } else if ("reference".equals(key.trim().toLowerCase())) {
            this.reference = Double.parseDouble(value.trim());
        } else if ("deviation".equals(key.trim().toLowerCase())) {
            this.deviation = Double.parseDouble(value.trim());
        }
    }

    @Override
    public void setInitParameter(String key, String value) {
    }

    @Override
    public void init() throws TeolennException {
    }

    protected void resetHistogram(double minValueHisto, double maxValueHisto) {
        this.histo = new Histogram(minValueHisto, maxValueHisto, 10);
    }

    public FloatMeasurement(double minValueHisto, double maxValueHisto) {
        this.histo = new Histogram(minValueHisto, maxValueHisto, 10);
    }
}

