/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement;

import fr.ens.transcriptome.teolenn.measurement.ChromosomeMeasurement;
import fr.ens.transcriptome.teolenn.measurement.ComplexityMeasurement;
import fr.ens.transcriptome.teolenn.measurement.GCPencentMeasurement;
import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.measurement.OligoLengthMeasurement;
import fr.ens.transcriptome.teolenn.measurement.OligoNameMeasurement;
import fr.ens.transcriptome.teolenn.measurement.OligoSequenceMeasurement;
import fr.ens.transcriptome.teolenn.measurement.OligoStartMeasurement;
import fr.ens.transcriptome.teolenn.measurement.TmMeasurement;
import fr.ens.transcriptome.teolenn.measurement.UnicityMeasurement;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MeasurementRegistery {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static Map<String, Class> registery = new HashMap<String, Class>();

    public static void addMeasurementType(String name, Class clazz) {
        if (name == null || clazz == null) {
            return;
        }
        if (MeasurementRegistery.testClassType(clazz)) {
            String lowerName = name.toLowerCase();
            if (registery.containsKey(lowerName)) {
                logger.warning("Measurement " + name + " already exits, override previous measurement.");
            }
            registery.put(lowerName, clazz);
            logger.finest("Add " + name + " to Measurements registery");
        } else {
            logger.warning("Addon " + name + " is not a measurement class");
        }
    }

    public static void addMeasurementType(String name, String className) {
        if (name == null || "".equals(name) || className == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(className);
            MeasurementRegistery.addMeasurementType(name, clazz);
            logger.info("Add external measurement: " + name);
        }
        catch (ClassNotFoundException e) {
            logger.severe("Cannot find " + className + " for " + name + " measurement addon");
            throw new RuntimeException("Cannot find " + className + " for " + name + " measurement addon");
        }
    }

    private static boolean testClassType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            return clazz.newInstance() instanceof Measurement;
        }
        catch (InstantiationException e) {
            logger.severe("Can't create instance of " + clazz.getName() + ". Maybe your class doesn't have a void constructor.");
        }
        catch (IllegalAccessException e) {
            logger.severe("Can't access to " + clazz.getName());
        }
        return false;
    }

    public static Measurement getMeasurement(String name) {
        if (name == null) {
            return null;
        }
        Class clazz = registery.get(name.toLowerCase());
        if (clazz == null) {
            return null;
        }
        try {
            return (Measurement)clazz.newInstance();
        }
        catch (InstantiationException e) {
            System.err.println("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            logger.severe("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    static {
        MeasurementRegistery.addMeasurementType("Chromosome", ChromosomeMeasurement.class);
        MeasurementRegistery.addMeasurementType("Complexity", ComplexityMeasurement.class);
        MeasurementRegistery.addMeasurementType("%GC", GCPencentMeasurement.class);
        MeasurementRegistery.addMeasurementType("OligoLength", OligoLengthMeasurement.class);
        MeasurementRegistery.addMeasurementType("OligoName", OligoNameMeasurement.class);
        MeasurementRegistery.addMeasurementType("OligoSequence", OligoSequenceMeasurement.class);
        MeasurementRegistery.addMeasurementType("OligoStart", OligoStartMeasurement.class);
        MeasurementRegistery.addMeasurementType("Tm", TmMeasurement.class);
        MeasurementRegistery.addMeasurementType("Unicity", UnicityMeasurement.class);
    }
}

