/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement;

import fr.ens.transcriptome.teolenn.Settings;
import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.core.SequenceCore;
import fr.ens.transcriptome.teolenn.measurement.FloatMeasurement;
import fr.ens.transcriptome.teolenn.resource.ChromosomeNameResource;
import fr.ens.transcriptome.teolenn.sequence.Sequence;
import fr.ens.transcriptome.teolenn.util.BinariesInstaller;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import fr.ens.transcriptome.teolenn.util.ProcessUtils;
import fr.ens.transcriptome.teolenn.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnicityMeasurement
extends FloatMeasurement {
    private static Logger logger = Logger.getLogger("Teolenn");
    public static final String MEASUREMENT_NAME = "Unicity";
    private static final String SEQ_GZ_WITHOUT_X_EXTENSION = ".seqX.fa.gz";
    private static final String MUP_EXTENSION = ".mup";
    private static final String MUP_DIR = "mup";
    private static final String IDX_DIR = "idx";
    private static final String FMIDX_DIR = "fmidx";
    private int oligoLength = 60;
    private int oligoIntervalLength = 0;
    private File genomeFile;
    private File baseDir;
    private int maxPrefixLength;
    private String currentChr;
    private Map<Integer, Integer> mupDict = new HashMap<Integer, Integer>();
    private double uniquenessMax;
    private int startOffset = 0;
    private final Map<Integer, Integer> mupEnd = new HashMap<Integer, Integer>();
    private static final Pattern seqNamePattern = Pattern.compile("^(.*):subseq\\((\\d+),(\\d+)\\)$");

    @Override
    protected float calcFloatMeasurement(Sequence sequence) {
        String sequenceName = sequence.getName();
        Matcher m = seqNamePattern.matcher(sequenceName);
        if (!m.matches()) {
            throw new RuntimeException("Unable to parse sequence name: " + sequenceName);
        }
        String chr = m.group(1);
        int startPos = Integer.parseInt(m.group(2));
        int len = sequence.getLengthOligo();
        try {
            if (!chr.equals(this.currentChr)) {
                this.parseResultFile(chr);
                this.currentChr = chr;
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading mup results: " + e.getMessage());
        }
        return this.uscoreCalculation(startPos + this.startOffset, len);
    }

    @Override
    public String getName() {
        return MEASUREMENT_NAME;
    }

    @Override
    public String getDescription() {
        return "Unicity Measurement";
    }

    @Override
    public float getScore(Object value) {
        double uniqueness = ((Float)value).doubleValue();
        return (float)(uniqueness / this.uniquenessMax);
    }

    @Override
    public void setProperty(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if ("max".equals(key)) {
            this.uniquenessMax = Double.parseDouble(value);
        } else {
            super.setProperty(key, value);
        }
    }

    private void build_fmindex(List<File> params) throws IOException {
        String o;
        int j;
        File idxDir = new File(this.baseDir, IDX_DIR);
        if (!idxDir.isDirectory() && !idxDir.mkdirs()) {
            throw new IOException("Can't create directory for index directory: " + idxDir.getAbsolutePath());
        }
        String[] idxOri = new String[]{"rev", "cpl"};
        for (File f : params) {
            String idxName = StringUtils.basename(f.getName());
            ProcessUtils.ParalellExec pexec = new ProcessUtils.ParalellExec(2, Settings.getMaxThreads());
            for (j = 0; j < idxOri.length; ++j) {
                o = idxOri[j];
                String cmd = Settings.getGenomeToolsPath() + " suffixerator -db " + f + " -dir " + o + " -indexname " + idxDir.getAbsolutePath() + File.separator + idxName + "." + o + " -dna -pl -suf -tis -lcp -bwt";
                pexec.addTask(cmd);
            }
            pexec.execTasks();
        }
        File fmidxDir = new File(this.baseDir, FMIDX_DIR);
        if (!fmidxDir.isDirectory() && !fmidxDir.mkdirs()) {
            throw new IOException("Can't create directory for fm index: " + fmidxDir.getAbsolutePath());
        }
        Object[] filesIndex = FileUtils.listFilesByExtension(idxDir, ".cpl.prj");
        Arrays.sort(filesIndex);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < filesIndex.length; ++i) {
            for (j = 0; j < idxOri.length; ++j) {
                o = idxOri[j];
                sb.append(StringUtils.basename(((File)filesIndex[i]).getAbsolutePath()));
                sb.append(".");
                sb.append(o);
                sb.append(" ");
            }
        }
        File fmidxFile = new File(fmidxDir, FileUtils.getPrefix(idxDir.listFiles()));
        String index = sb.toString();
        String cmd2 = Settings.getGenomeToolsPath() + " mkfmindex -fmout " + fmidxFile + " -size small -noindexpos -ii " + index;
        ProcessUtils.exec(cmd2, Settings.isStandardOutputForExecutable());
        String cmd3 = Settings.getGenomeToolsPath() + " suffixerator -plain -tis -indexname " + fmidxFile + " -smap " + fmidxFile + ".al1 -db " + fmidxFile + ".bwt";
        ProcessUtils.exec(cmd3, Settings.isStandardOutputForExecutable());
    }

    private void run_uniquesub(List<File> filesToProcess, String basename, int maxPrefixLength) throws IOException {
        File mupDir = new File(this.baseDir, MUP_DIR);
        File fmidxDir = new File(this.baseDir, FMIDX_DIR);
        if (!mupDir.isDirectory() && !mupDir.mkdirs()) {
            throw new IOException("Can't create directory for mup directory: " + mupDir.getAbsolutePath());
        }
        ProcessUtils.ParalellExec pexec = new ProcessUtils.ParalellExec(1, Settings.getMaxThreads());
        for (File f : filesToProcess) {
            String cmd = Settings.getGenomeToolsPath() + " uniquesub -output querypos sequence -max " + maxPrefixLength + " -fmi " + fmidxDir.getAbsolutePath() + File.separator + basename + " -query " + f.getAbsolutePath();
            String outname = StringUtils.basename(f.getName()) + MUP_EXTENSION;
            pexec.addTask(cmd, new File(mupDir, outname));
        }
        pexec.execTasks();
    }

    private float uscoreCalculation(int sequenceStart, int len) {
        int sequenceEnd = sequenceStart + len - 1;
        this.mupEnd.clear();
        for (int sequencePosition = sequenceStart; sequencePosition <= sequenceEnd; ++sequencePosition) {
            int temp_mup_end;
            if (!this.mupDict.containsKey(sequencePosition) || (temp_mup_end = sequencePosition + this.mupDict.get(sequencePosition) - 1) > sequenceEnd) continue;
            int val = this.mupEnd.containsKey(temp_mup_end) ? this.mupEnd.get(temp_mup_end) : 0;
            this.mupEnd.put(temp_mup_end, val + 1);
        }
        return this.mupEnd.size();
    }

    private void parseResultFile(String chromosome) throws IOException {
        File mupDir = new File(this.baseDir, MUP_DIR);
        File file = new File(mupDir, chromosome + MUP_EXTENSION);
        logger.fine("Parse file: " + file.getName() + " in " + MEASUREMENT_NAME + " measurement.");
        this.mupDict.clear();
        BufferedReader br = FileUtils.createBufferedReader(file);
        String line = null;
        Pattern lineSplitPattern = Pattern.compile(" ");
        while ((line = br.readLine()) != null) {
            if (!Character.isDigit(line.charAt(0))) continue;
            String[] line_attributes = lineSplitPattern.split(line);
            int pos = Integer.parseInt(line_attributes[0]);
            int len = Integer.parseInt(line_attributes[1]);
            this.mupDict.put(pos, len);
        }
        br.close();
    }

    @Override
    public void setInitParameter(String key, String value) {
        if ("_start1".equals(key)) {
            boolean start1 = Boolean.parseBoolean(value);
            this.startOffset = start1 ? -1 : 0;
        } else if ("_oligolength".equals(key)) {
            this.oligoLength = Integer.parseInt(value);
        } else if ("_oligointervallength".equals(key)) {
            this.oligoIntervalLength = Integer.parseInt(value);
        } else if ("_genomefile".equals(key)) {
            this.genomeFile = new File(value);
        } else if ("_tempdir".equals(key)) {
            this.baseDir = new File(value);
        } else if ("maxprefixlength".equals(key)) {
            this.maxPrefixLength = Integer.parseInt(value);
        }
    }

    @Override
    public void init() throws TeolennException {
        try {
            Level l;
            File gtDataDir;
            if (Settings.getGenomeToolsPath() == null) {
                Settings.setGenomeToolsPath(BinariesInstaller.install("gt"));
            }
            if (!(gtDataDir = new File(new File(Settings.getGenomeToolsPath()).getParent(), "gtdata")).exists()) {
                gtDataDir.mkdirs();
            }
            if ((l = logger.getLevel()).equals(Level.FINE) || l.equals(Level.FINER) || l.equals(Level.FINEST) || l.equals(Level.INFO)) {
                logger.info("genometools version: " + this.getGenomeToolsVersion());
            }
            if (this.oligoLength < 0) {
                throw new TeolennException("OligoLength parameter is invalid: " + this.oligoLength);
            }
            if (this.oligoIntervalLength < 0) {
                throw new TeolennException("OligoIntervalLength parameter is invalid: " + this.oligoIntervalLength);
            }
            this.resetHistogram(0.0, this.oligoLength + this.oligoIntervalLength);
            SequenceCore.fastaExplode(this.genomeFile, this.baseDir, "", SEQ_GZ_WITHOUT_X_EXTENSION, true, true);
            List<String> chrNames = ChromosomeNameResource.getRessource().getChromosomesNames();
            ArrayList<File> files = new ArrayList<File>(chrNames.size());
            for (String chrName : chrNames) {
                files.add(new File(this.baseDir, chrName + SEQ_GZ_WITHOUT_X_EXTENSION));
            }
            this.build_fmindex(files);
            this.run_uniquesub(files, FileUtils.getPrefix(files), this.maxPrefixLength);
        }
        catch (IOException e) {
            throw new TeolennException("Unable to inittialize Unicity measurement: " + e.getMessage());
        }
    }

    private String getGenomeToolsVersion() {
        String cmd = Settings.getGenomeToolsPath() + " -version";
        try {
            String[] lines;
            String output = ProcessUtils.execToString(cmd);
            if (output != null && (lines = output.split("\n")) != null && lines.length > 0) {
                return lines[0];
            }
        }
        catch (IOException e) {
            logger.severe("Unable to get genometools version. If you are using a x86-64 version of linux, you must install ia32-libs package to run genometools." + e.getMessage());
            throw new RuntimeException(e);
        }
        return "";
    }

    public UnicityMeasurement() {
        super(0.0, 1.0);
    }
}

