/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.filter;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilter;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import java.security.InvalidParameterException;

public class BooleanFilter
implements MeasurementFilter {
    public static final String MEASUREMENT_FILTER_NAME = "booleanfilter";
    private String field;
    private int index = -1;
    private boolean acceptValue;

    public String getName() {
        return MEASUREMENT_FILTER_NAME;
    }

    public String getDescription() {
        return "Filter boolean measurements";
    }

    public boolean accept(SequenceMeasurements sm) {
        Object[] values;
        if (this.index == -1) {
            this.index = sm.getIndexMeasurment(this.field);
        }
        if ((values = sm.getArrayMeasurementValues()) == null) {
            return false;
        }
        boolean b = (Boolean)values[this.index];
        return b == this.acceptValue;
    }

    public void setInitParameter(String key, String value) {
        if ("measurement".equals(key) && value != null) {
            this.field = value;
        }
        if ("acceptValue".equals(key) && value != null) {
            this.acceptValue = Boolean.parseBoolean(value);
        }
    }

    public void init() throws TeolennException {
        if (this.field == null) {
            throw new InvalidParameterException("The field value is unknown for booleanfilter filter.");
        }
    }

    public BooleanFilter() {
    }

    public BooleanFilter(String field, boolean acceptValue) {
        if (field == null) {
            throw new NullPointerException("field value is  null");
        }
        this.field = field;
        this.acceptValue = acceptValue;
    }
}

