/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.filter;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilter;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import java.util.logging.Logger;

public class FloatRangeFilter
implements MeasurementFilter {
    private static Logger logger = Logger.getLogger("Teolenn");
    public static final String MEASUREMENT_FILTER_NAME = "floatrange";
    private String field;
    private int index = -1;
    private float min;
    private float max;

    public String getName() {
        return MEASUREMENT_FILTER_NAME;
    }

    public String getDescription() {
        return "Filter floats measurements";
    }

    public boolean accept(SequenceMeasurements sm) {
        Object[] values;
        if (sm == null) {
            return false;
        }
        if (this.index == -1) {
            this.index = sm.getIndexMeasurment(this.field.toLowerCase());
            if (this.index == -1) {
                logger.severe("Unknown measurement: " + this.field);
                throw new RuntimeException("In floatrange, unknown measurement: " + this.field);
            }
        }
        if ((values = sm.getArrayMeasurementValues()) == null) {
            return false;
        }
        float f = ((Float)values[this.index]).floatValue();
        return this.min <= f && f <= this.max;
    }

    public void setInitParameter(String key, String value) {
        if ("measurement".equals(key) && value != null) {
            this.field = value;
        } else if ("min".equals(key) && value != null) {
            this.min = Float.parseFloat(value);
        } else if ("max".equals(key) && value != null) {
            this.max = Float.parseFloat(value);
        }
    }

    public void init() throws TeolennException {
        if (this.field == null) {
            throw new TeolennException("Invalid parameter: The Field value is unknown for floatrange filter.");
        }
        if (this.min > this.max) {
            float tmp = this.min;
            this.min = this.max;
            this.max = tmp;
        }
    }

    public FloatRangeFilter() {
    }

    public FloatRangeFilter(String field, float min, float max) {
        if (min < max) {
            this.min = min;
            this.max = max;
        } else {
            this.min = max;
            this.max = min;
        }
        this.field = field;
    }
}

