/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.filter;

import fr.ens.transcriptome.teolenn.measurement.filter.BooleanFilter;
import fr.ens.transcriptome.teolenn.measurement.filter.FloatRangeFilter;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilter;
import fr.ens.transcriptome.teolenn.measurement.filter.ORFsFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;

public class MeasurementFilterRegistery {
    private static Logger logger = Logger.getLogger("Teolenn");
    private static Map<String, Class> registery = new HashMap<String, Class>();

    public static void addMeasurementFilterType(String name, Class clazz) {
        if (name == null || clazz == null) {
            return;
        }
        String lowerName = name.toLowerCase();
        if (registery.containsKey(lowerName)) {
            logger.warning("Measurement filter " + name + " already exits, override previous measurement filter.");
        }
        registery.put(lowerName, clazz);
    }

    public static void addMeasurementFilterType(String name, String className) {
        if (name == null || "".equals(name) || className == null) {
            return;
        }
        try {
            Class<?> clazz = Class.forName(className);
            MeasurementFilterRegistery.addMeasurementFilterType(name.toLowerCase(), clazz);
            logger.info("Add external measurement: " + name);
        }
        catch (ClassNotFoundException e) {
            logger.severe("Cannot find " + className + " for " + name + " measurement filter addon");
            throw new RuntimeException("Cannot find " + className + " for " + name + " measurement filter addon");
        }
    }

    private static boolean testClassType(Class clazz) {
        if (clazz == null) {
            return false;
        }
        try {
            return clazz.newInstance() instanceof MeasurementFilter;
        }
        catch (InstantiationException e) {
            logger.severe("Can't create instance of " + clazz.getName() + ". Maybe your class doesn't have a void constructor.");
        }
        catch (IllegalAccessException e) {
            logger.severe("Can't access to " + clazz.getName());
        }
        return false;
    }

    public static MeasurementFilter getMeasuremrentFilter(String name) {
        if (name == null) {
            return null;
        }
        Class clazz = registery.get(name.toLowerCase());
        if (clazz == null) {
            return null;
        }
        try {
            return (MeasurementFilter)clazz.newInstance();
        }
        catch (InstantiationException e) {
            System.err.println("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            logger.severe("Unable to instantiate " + name + " filter. Maybe this filter doesn't have a void constructor.");
            return null;
        }
        catch (IllegalAccessException e) {
            return null;
        }
    }

    static {
        MeasurementFilterRegistery.addMeasurementFilterType("floatrange", FloatRangeFilter.class);
        MeasurementFilterRegistery.addMeasurementFilterType("booleanfilter", BooleanFilter.class);
        MeasurementFilterRegistery.addMeasurementFilterType("orfsfilter", ORFsFilter.class);
    }
}

