/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.filter;

import fr.ens.transcriptome.teolenn.TeolennException;
import fr.ens.transcriptome.teolenn.measurement.filter.MeasurementFilter;
import fr.ens.transcriptome.teolenn.resource.ORFResource;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import java.io.IOException;
import java.util.Properties;

public class ORFsFilter
implements MeasurementFilter {
    public static final String MEASUREMENT_FILTER_NAME = "orfsfilter";
    private ORFResource ressource;
    private Properties ressourceProperties = new Properties();
    private boolean first = true;
    private int colChromosome;
    private int colOligoStart;
    private int colOligoLength;

    public String getName() {
        return MEASUREMENT_FILTER_NAME;
    }

    public String getDescription() {
        return "Filter ORFs";
    }

    public boolean accept(SequenceMeasurements sm) throws TeolennException {
        int pos;
        Object[] values;
        String chr;
        if (this.first) {
            this.colChromosome = sm.getIndexMeasurment("Chromosome");
            if (this.colChromosome == -1) {
                throw new TeolennException("The Chromosome measurement is mandatory to use orfsfilter filter.");
            }
            this.colOligoStart = sm.getIndexMeasurment("OligoStart");
            if (this.colOligoStart == -1) {
                throw new TeolennException("The OligoStart measurement is mandatory to use orfsfilter filter.");
            }
            this.colOligoLength = sm.getIndexMeasurment("OligoLength");
            if (this.colOligoLength == -1) {
                throw new TeolennException("The OligoStart measurement is mandatory to use orfsfilter filter.");
            }
            this.first = false;
        }
        return this.ressource.getORF(chr = (String)(values = sm.getArrayMeasurementValues())[this.colChromosome], pos = ((Integer)values[this.colOligoStart]).intValue(), this.colOligoLength) != null;
    }

    public void setInitParameter(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        this.ressourceProperties.setProperty(key.toLowerCase(), value);
    }

    public void init() throws TeolennException {
        try {
            this.ressource = ORFResource.getRessource(this.ressourceProperties);
        }
        catch (IOException e) {
            throw new TeolennException(e);
        }
    }
}

