/*
 * Decompiled with CFR 0.152.
 */
package fr.ens.transcriptome.teolenn.measurement.io;

import fr.ens.transcriptome.teolenn.measurement.Measurement;
import fr.ens.transcriptome.teolenn.measurement.MeasurementRegistery;
import fr.ens.transcriptome.teolenn.measurement.io.SequenceMeasurementsReader;
import fr.ens.transcriptome.teolenn.sequence.SequenceMeasurements;
import fr.ens.transcriptome.teolenn.util.FileUtils;
import fr.ens.transcriptome.teolenn.util.StringUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.regex.Pattern;

public final class FileSequenceMeasurementsReader
implements SequenceMeasurementsReader {
    private BufferedReader br;
    private String infoCurrentFile;
    private Measurement[] ms;
    private String[] tokens;
    private static final Pattern tabPattern = Pattern.compile("\t");

    private void readHeader() throws IOException {
        String line = this.br.readLine();
        if (line == null) {
            throw new IOException("File is empty" + this.infoCurrentFile == null ? "" : this.infoCurrentFile);
        }
        String[] mNames = tabPattern.split(line);
        this.ms = new Measurement[mNames.length - 1];
        for (int i = 1; i < mNames.length; ++i) {
            Measurement m = MeasurementRegistery.getMeasurement(mNames[i]);
            if (m == null) {
                throw new RuntimeException("Unknown measurement: " + mNames[i]);
            }
            this.ms[i - 1] = m;
        }
    }

    public SequenceMeasurements next() throws IOException {
        return this.next(null);
    }

    public SequenceMeasurements next(SequenceMeasurements sm) throws IOException {
        SequenceMeasurements result;
        if (sm == null) {
            result = new SequenceMeasurements();
            for (int i = 0; i < this.ms.length; ++i) {
                result.addMesurement(this.ms[i]);
            }
            result.setArrayMeasurementValues(new Object[this.ms.length]);
            this.tokens = new String[this.ms.length + 1];
        } else {
            result = sm;
        }
        String line = this.br.readLine();
        if (line == null) {
            return null;
        }
        StringUtils.fastSplit(line, this.tokens);
        result.setId(Integer.parseInt(this.tokens[0]));
        Object[] values = result.getArrayMeasurementValues();
        for (int i = 0; i < this.ms.length; ++i) {
            values[i] = this.ms[i].parse(this.tokens[i + 1]);
        }
        return result;
    }

    public void close() throws IOException {
        this.br.close();
    }

    public FileSequenceMeasurementsReader(File file) throws IOException {
        if (file == null) {
            throw new NullPointerException("File is null");
        }
        this.infoCurrentFile = file.getName();
        this.br = FileUtils.createBufferedReader(file);
        this.readHeader();
    }
}

